/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.qlb.dc.service.api;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.qlb.dc.service.QLBDCCommConfig;
import kd.ebg.receipt.banks.qlb.dc.service.SignUtil;
import kd.ebg.receipt.banks.qlb.dc.service.api.QlbUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Element;

public class HisBankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        String transDate = bankReceiptRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String bankLoginID = EBContext.getContext().getBankLoginID();
        QLBDCCommConfig config = (QLBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(QLBDCCommConfig.class, bankLoginID);
        Map paramsMap = bankReceiptRequest.getParamsMap();
        String transferFlowNo = (String)paramsMap.get("transferFlowNo");
        String dbusLogNum = (String)paramsMap.get("dbusLogNum");
        String tranDate = (String)paramsMap.get("tranDate");
        String cmchannelType = (String)paramsMap.get("cmchannelType");
        String printNum = (String)paramsMap.get("PrintNum");
        String receiptType = (String)paramsMap.get("receiptType");
        String templetNo = (String)paramsMap.get("templetNo");
        String diskPartition = (String)paramsMap.get("diskPartition");
        Element root = JDomExtUtils.createRoot((String)"QLBankData");
        Element opReq = JDomUtils.addChild((Element)root, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)"CBE016");
        JDomUtils.addChild((Element)opReq, (String)"cstNo", (String)config.getCstNo());
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)Sequence.gen18Sequence());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)ReqParam, (String)"startIntcDate", (String)transDate);
        JDomUtils.addChild((Element)ReqParam, (String)"endIntcDate", (String)transDate);
        JDomUtils.addChild((Element)ReqParam, (String)"transferFlowNo", (String)transferFlowNo);
        JDomUtils.addChild((Element)ReqParam, (String)"dbusLogNum", (String)dbusLogNum);
        JDomUtils.addChild((Element)ReqParam, (String)"tranDate", (String)tranDate);
        JDomUtils.addChild((Element)ReqParam, (String)"cmchannelType", (String)cmchannelType);
        JDomUtils.addChild((Element)ReqParam, (String)"PrintNum", (String)printNum);
        JDomUtils.addChild((Element)ReqParam, (String)"receiptType", (String)receiptType);
        JDomUtils.addChild((Element)ReqParam, (String)"templetNo", (String)templetNo);
        JDomUtils.addChild((Element)ReqParam, (String)"diskPartition", (String)diskPartition);
        SignUtil signUtil = new SignUtil();
        String reqStr = JDomUtils.root2String((Element)root, (String)"GBK");
        bankReceiptRequest.setRequestStr(reqStr);
        BankReceiptResponseEB signResp = signUtil.doBiz(bankReceiptRequest);
        String signStr = (String)signResp.getData();
        return "CBE016|#" + signStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        String[] head = s.split("\\|");
        String retCode = head[0];
        String retMsg = head[1];
        if (!"0000".equalsIgnoreCase(retCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s \u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"HisBankReceiptImpl_0", (String)"ebg-receipt-banks-qlb-dc", (Object[])new Object[0]), retCode, retMsg));
        }
        s = QlbUtil.parseMessage(s);
        Element root = JDomUtils.string2Root((String)s, (String)"GBK");
        Element opRep = JDomExtUtils.getUnNullChildElement((Element)root, (String)"opRep");
        Element opResult = JDomExtUtils.getUnNullChildElement((Element)opRep, (String)"opResult");
        String downloadURL = JDomUtils.getUnNullChildText((Element)opResult, (String)"downloadURL");
        return BankReceiptResponseEB.success((Object)downloadURL);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE016";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/yqbank/APIQLReqServlet");
    }
}

