/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.qlb.dc.service.api;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.qlb.dc.service.QLBDCCommConfig;
import kd.ebg.receipt.banks.qlb.dc.service.SignUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Element;

public class TodayBankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        QLBDCCommConfig config = (QLBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(QLBDCCommConfig.class, bankLoginID);
        Map paramsMap = bankReceiptRequest.getParamsMap();
        String tftprtmhd = (String)paramsMap.get("tftprtmhd");
        String tranDate = (String)paramsMap.get("tranDate");
        String transferFlowNo = (String)paramsMap.get("transferFlowNo");
        String cmchannelType = (String)paramsMap.get("cmchannelType");
        String busnType = (String)paramsMap.get("busnType");
        Element root = JDomExtUtils.createRoot((String)"QLBankData");
        Element opReq = JDomUtils.addChild((Element)root, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)"CBE014");
        JDomUtils.addChild((Element)opReq, (String)"cstNo", (String)config.getCstNo());
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)Sequence.gen18Sequence());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)ReqParam, (String)"tftprtmhd", (String)tftprtmhd);
        JDomUtils.addChild((Element)ReqParam, (String)"tranDate", (String)tranDate);
        JDomUtils.addChild((Element)ReqParam, (String)"transferFlowNo", (String)transferFlowNo);
        JDomUtils.addChild((Element)ReqParam, (String)"cmchannelType", (String)cmchannelType);
        JDomUtils.addChild((Element)ReqParam, (String)"busnType", (String)busnType);
        SignUtil signUtil = new SignUtil();
        String reqStr = JDomUtils.root2String((Element)root, (String)"GBK");
        bankReceiptRequest.setRequestStr(reqStr);
        BankReceiptResponseEB signResp = signUtil.doBiz(bankReceiptRequest);
        String signStr = (String)signResp.getData();
        return "CBE014|#" + signStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        String[] head = s.split("\\|");
        String retCode = head[0];
        String retMsg = head[1];
        if (!"0000".equalsIgnoreCase(retCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s \u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"TodayBankReceiptImpl_1", (String)"ebg-receipt-banks-qlb-dc", (Object[])new Object[0]), retCode, retMsg));
        }
        Element root = JDomUtils.string2Root((String)s, (String)"GBK");
        Element opRep = JDomUtils.getUnNullChildElement((Element)root, (String)"opRep");
        Element opResult = JDomUtils.getUnNullChildElement((Element)opRep, (String)"opResult");
        String downloadURL = JDomUtils.getUnNullChildText((Element)opResult, (String)"downloadURL");
        return BankReceiptResponseEB.success((Object)downloadURL);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE014";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/yqbank/APIQLReqServlet");
    }
}

