/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.psbc.srdc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        ChannelSftp sftp = null;
        String bankLogin = request.getBankLoginId();
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp") && SFTPUtils.getInstance().isAbort(sftp)) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        boolean isLastFile = false;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(downloadListDetails.size());
        String bakPathParentPath = FileStorageUtil.getFileBakPath((String)bankLogin) + File.separator + transDate;
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
            String fileName = downloadListDetail.getFileLink();
            String savePath = bakFilePath;
            if (fileName.contains(".zip")) {
                savePath = bakPathParentPath;
                logger.info("\u90ae\u50a8\u94f6\u884c\u7535\u5b50\u56de\u5355\u63a8\u9001\u683c\u5f0f\u4e3azip\u5305");
            } else {
                logger.info("\u90ae\u50a8\u94f6\u884c\u7535\u5b50\u56de\u5355\u63a8\u9001\u683c\u5f0f\u4e3apdf");
            }
            boolean isSuccess = this.download(downloadListDetail, savePath, bankLogin, isLastFile, bankFtpProperties, sftp);
            if (!isSuccess) continue;
            result.addAll(this.handleDownloaded(downloadListDetail, task, savePath));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String bakFilePath, String bankLogin, boolean isLastFile, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        boolean result = false;
        String ftpPath = "/";
        String accNo = detail.getAccNo();
        LocalDate transDate = detail.getTransDate();
        try {
            File receiptFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + detail.getFileLink()));
            if (receiptFile.exists()) {
                boolean bl = true;
                return bl;
            }
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                }
                if (StringUtils.isNotEmpty((String)bankFtpProperties.getFtpPath())) {
                    ftpPath = bankFtpProperties.getFtpPath();
                }
                result = SFTPUtils.getInstance().downloadSingleFile(ftpPath, detail.getFileLink(), bakFilePath, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                result = bankReceiptApiUtil.downloadReceiptFile(detail.getFileLink(), bakFilePath);
            }
            if (!result) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:%s\u3002", (String)"BankReceiptDownloadImpl_5", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]), detail.getFileLink()));
            }
        }
        catch (Exception e) {
            String msg = ErrorMsgUtil.getSFTPErrorMSG((String)detail.getFileLink(), (String)e.getMessage());
            throw new ReceiptException(msg, (Throwable)e);
        }
        finally {
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
        return true;
    }

    public List<DownloadListDetail> handleDownloaded(DownloadListDetail detail, DownloadListTask task, String savePath) {
        String fileName = detail.getFileLink();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        if (fileName.contains(".zip")) {
            return this.handDownloadedZip(detail, task, savePath);
        }
        File file = FileCommonUtils.getFileByPath((String)(savePath + File.separator + detail.getFileLink()));
        if (file.exists()) {
            FileCommonUtils.moveFile((File)file, (String)savePath, (String)detail.getFileName());
            result.add(detail);
            return result;
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0d\u5b58\u5728:", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]), detail.getFileLink()));
    }

    public List<DownloadListDetail> handDownloadedZip(DownloadListDetail detail, DownloadListTask task, String savePath) {
        String tempPath = savePath + File.separator + "temp" + File.separator + detail.getAccNo();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)task.getBankVersionId(), (String)task.getAccNo(), (String)LocalDateUtil.formatDate((LocalDate)task.getTransDate()));
        String zipFilePath = savePath + File.separator + detail.getFileLink();
        boolean flag = BankReceiptDownloadImpl.unZipFiles(zipFilePath, tempPath);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        String newFileName = detail.getFileName();
        if (flag) {
            File unZipDir = FileCommonUtils.getFileByPath((String)tempPath);
            if (unZipDir.isDirectory()) {
                File[] files;
                for (File receiptFile : files = unZipDir.listFiles()) {
                    if (receiptFile.isDirectory()) {
                        File[] nextFileList;
                        String nextPath = tempPath + File.separator + receiptFile.getName();
                        File nextFile = FileCommonUtils.getFileByPath((String)nextPath);
                        for (File nextReceiptFile : nextFileList = nextFile.listFiles()) {
                            this.packDetail(bakFilePath, result, newFileName, nextReceiptFile);
                        }
                    }
                    this.packDetail(bakFilePath, result, newFileName, receiptFile);
                }
                boolean isDelete = unZipDir.delete();
                logger.info("\u6587\u4ef6\u662f\u5426\u88ab\u5220\u9664-{}\uff1a{}", new Object[]{unZipDir.getName(), isDelete});
            }
            return result;
        }
        StringBuilder error = new StringBuilder();
        error.append(ResManager.loadKDString((String)"\u538b\u7f29\u5305", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0])).append(detail.getFileLink()).append(ResManager.loadKDString((String)"\u89e3\u538b\u7f29\u5931\u8d25", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
        throw new ReceiptException(error.toString());
    }

    public void packDetail(String bakFilePath, List<DownloadListDetail> result, String newFileName, File receiptFile) {
        if (receiptFile.isFile()) {
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(newFileName);
            downloadListDetail.setFileLink(receiptFile.getName());
            result.add(downloadListDetail);
            boolean isMove = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)newFileName);
            if (isMove) {
                boolean isDelete = receiptFile.delete();
                logger.info("\u6587\u4ef6\u662f\u5426\u88ab\u5220\u9664-{}\uff1a{}", new Object[]{receiptFile.getName(), isDelete});
            }
        }
    }

    public static boolean unZipFiles(String zipFilePath, String descDir) {
        boolean flag = false;
        File zipFile = FileCommonUtils.getFileByPath((String)zipFilePath);
        File pathFile = FileCommonUtils.getFileByPath((String)descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    String outPath = (descDir + zipEntryName.substring(zipEntryName.indexOf("/"))).replaceAll("\\*", "/");
                    File file = FileCommonUtils.getFileByPath((String)outPath.substring(0, outPath.lastIndexOf(47)));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (FileCommonUtils.getFileByPath((String)outPath).isDirectory()) continue;
                    logger.info("\u51c6\u5907\u89e3\u538b: " + outPath);
                    FileOutputStream out = new FileOutputStream(outPath);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] buf1 = new byte[4096];
                        while ((len = in.read(buf1)) > 0) {
                            ((OutputStream)out).write(buf1, 0, len);
                        }
                        logger.info("\u89e3\u538b" + outPath + " \u5b8c\u6210\u3002");
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u89e3\u538b\u7f29\u5931\u8d25", (Throwable)e);
        }
        return flag;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PSBC_SRDC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u90ae\u653f\u50a8\u84c4\u94f6\u884c\u76f4\u8054\u7cfb\u7edf\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]);
    }
}

