/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.psbc.srdc.service.receipt;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.receipt.banks.psbc.srdc.service.receipt.ResponseParser;
import kd.ebg.receipt.banks.psbc.srdc.service.receipt.api.ReceiptInfoRequestImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String acno = task.getAccNo();
        String TransDate = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        List<DetailInfo> EnterpriseID_list = ResponseParser.getDetailList(acno, task.getTransDate());
        if (EnterpriseID_list.size() == 0) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff1a\u67e5\u8be2\u65e5\u671f[%s]\u7684\u4ea4\u6613\u660e\u7ec6\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]), task.getTransDate()));
        }
        for (int i = 0; i < EnterpriseID_list.size(); ++i) {
            DetailInfo detailInfo = EnterpriseID_list.get(i);
            BankReceiptRequest request = BankReceiptRequest.builder().accNo(acno).transDate(task.getTransDate()).requestStr(detailInfo.getExplanation()).build();
            logger.info("\u90ae\u50a8SRDC-5006-{}-{}-\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u540d-\u5bf9\u5e94\u7b2c{}\u4f4d\u7684\u4ea4\u6613\u660e\u7ec6\u6d41\u6c34-\u56de\u5355\u53f7\uff1a{}", new Object[]{acno, task.getTransDate(), i + 1, detailInfo.getExplanation()});
            ReceiptInfoRequestImpl iBankReceipt = new ReceiptInfoRequestImpl();
            BankReceiptResponseEB response = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)request);
            String PDFName = (String)response.getData();
            StringBuilder builder = new StringBuilder();
            builder.append(acno).append("-").append(TransDate).append("-").append(detailInfo.getExplanation()).append("-").append(detailInfo.getUniqueSeq()).append(".").append("pdf");
            String newFileName = builder.toString();
            logger.info("\u90ae\u50a8SRDC-5006-{}-{}-\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u540d-\u5bf9\u5e94\u7b2c{}\u4f4d\u7684\u4ea4\u6613\u660e\u7ec6\u6d41\u6c34-\u56de\u5355\u53f7\uff1a{}-\u6587\u4ef6\u540d\u4e3a\uff1a{}", new Object[]{acno, task.getTransDate(), i + 1, detailInfo.getExplanation(), PDFName});
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(PDFName);
            detail.setFileName(newFileName);
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u5df2\u4e0b\u8f7d\u6210\u529f\uff0c\u5c06\u4e0d\u518d\u91cd\u590d\u4e0b\u8f7d\uff08\u8bf7\u68c0\u67e5\u5907\u4efd\u76ee\u5f55\uff09\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_3", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PSBC_SRDC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u4e2d\u56fd\u90ae\u653f\u50a8\u84c4\u94f6\u884c\u76f4\u8054\u7cfb\u7edf\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]);
    }
}

