/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbb.opa.service.receipt.download;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.nbb.opa.service.receipt.api.GetReceiptDownloadUrlImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String accNo = request.getAccNo();
        String transDateStr = request.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate transDate = request.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        String downloadNo = "";
        for (DownloadListDetail detail : downloadListDetails) {
            if (!detail.getFileName().endsWith(".zip")) continue;
            downloadNo = detail.getFileLink();
            break;
        }
        if (EBGStringUtils.isNotEmpty((String)downloadNo)) {
            ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(transDate).accNo(accNo).build();
            GetReceiptDownloadUrlImpl getReceiptDownloadUrl = new GetReceiptDownloadUrlImpl();
            bankReceiptRequest.setRequestStr(downloadNo);
            BankReceiptResponseEB responseEB = getReceiptDownloadUrl.doBiz(bankReceiptRequest);
            if (responseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
                List urls = (List)responseEB.getData();
                for (String fileUrl : urls) {
                    if (fileUrl.contains("http")) {
                        RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"http");
                    } else {
                        RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"https");
                    }
                    String fileName = String.format("%s_%s_%s.zip", accNo, transDateStr, Sequence.gen18Sequence());
                    DownloadUtils.download((String)fileUrl, (String)fileName, (String)bakFilePath);
                    result.addAll(this.handZip(fileName, bakFilePath, accNo, transDateStr));
                }
                return BankReceiptHandleResponseEB.success(result);
            }
            return BankReceiptHandleResponseEB.fail();
        }
        return BankReceiptHandleResponseEB.fail();
    }

    public List<DownloadListDetail> handZip(String zipName, String bakFilePath, String accNo, String transDateStr) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        File zipFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + zipName));
        HashMap detailNoMap = Maps.newHashMapWithExpectedSize((int)1);
        if (zipFile.exists()) {
            String unZipPath = bakFilePath + File.separator + zipName.replace(".zip", "");
            if (GZFileUtils.unZipFiles((String)zipFile.getPath(), (String)unZipPath)) {
                File[] listFile = FileCommonUtils.getFileByPath((String)unZipPath).listFiles();
                ArrayList<DownloadListDetail> downloadListDetailList = new ArrayList<DownloadListDetail>(1);
                String txtFilePath = null;
                for (File file : listFile) {
                    if (!file.isFile() || !file.getName().endsWith(".txt")) continue;
                    downloadListDetailList.addAll(this.handTxtFile(file, accNo, transDateStr, detailNoMap));
                    txtFilePath = file.getPath();
                }
                if (downloadListDetailList.size() > 0) {
                    for (DownloadListDetail downloadListDetail : downloadListDetailList) {
                        boolean isMove;
                        String fileLink = downloadListDetail.getFileLink();
                        String fileName = downloadListDetail.getFileName();
                        File receiptFile = FileCommonUtils.getFileByPath((String)(unZipPath + File.separator + fileLink));
                        if (!receiptFile.exists() || !(isMove = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)fileName))) continue;
                        result.add(downloadListDetail);
                    }
                    if (txtFilePath != null) {
                        FileCommonUtils.deleteFile(txtFilePath);
                    }
                }
                FileCommonUtils.deleteFile((String)unZipPath);
                FileCommonUtils.deleteFile((File)zipFile);
            }
        }
        return result;
    }

    public List<DownloadListDetail> handTxtFile(File txtFile, String accNo, String transDateStr, Map<String, Integer> detailNoMap) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        try (FileInputStream fis = new FileInputStream(txtFile);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
             BufferedReader br = new BufferedReader(isr);){
            String line = "";
            boolean isFirst = true;
            while ((line = br.readLine()) != null) {
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                String[] strArr = line.split("\\@\\\\\\|");
                if (strArr == null) continue;
                String json = MatchRule.getInstance().getDetailJsonWithNonStructuredData("seqNo@\\|pdfFileName@\\|accName@\\|accNo@\\|bankName@\\|oppAccName@\\|oppAccNo@\\|oppBankName@\\|transAmt@\\|currency@\\|transType@\\|transDate@\\|receiptNo@\\|voucherNo@\\|subSerialNo@\\|cdFlag@\\|newReceiptNo", line, "\\@\\\\\\|");
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setReceiptJson(json);
                String pdfFileName = jsonObject.getString("pdfFileName");
                String fileName = BankReceiptDownloadImpl.packFileName(accNo, transDateStr, jsonObject, pdfFileName);
                downloadListDetail.setFileLink(pdfFileName);
                downloadListDetail.setFileName(fileName);
                downloadListDetail.setReceiptJson(jsonObject.toJSONString());
                String detailNo = MatchRule.getInstance().getReceiptMatchNo(accNo, transDateStr, downloadListDetail.getReceiptJson());
                if (detailNoMap.containsKey(detailNo)) {
                    int recount = detailNoMap.get(detailNo);
                    detailNoMap.put(detailNo, ++recount);
                    detailNo = detailNo + "-" + String.format("%04d", recount);
                } else {
                    detailNoMap.put(detailNo, 0);
                }
                downloadListDetail.setDetailNo(detailNo);
                result.add(downloadListDetail);
            }
        }
        catch (Throwable e) {
            logger.error(e.toString(), e);
        }
        return result;
    }

    public static String packFileName(String accNo, String transDateStr, JSONObject jsonObject, String pdfFileName) {
        String cdFlag = jsonObject.getString("cdFlag");
        String voucherNo = jsonObject.getString("voucherNo");
        String subSerialNo = jsonObject.getString("subSerialNo");
        String transAmt = jsonObject.getString("transAmt");
        StringBuilder sb = new StringBuilder();
        sb.append(accNo).append("_");
        sb.append(transDateStr).append("_");
        sb.append(cdFlag).append("_");
        sb.append(voucherNo).append("_");
        sb.append(subSerialNo).append("_");
        sb.append(transAmt).append("_");
        sb.append(pdfFileName);
        return sb.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

