/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbb.opa.service.receipt.utils;

import com.nbcb.sdk.OpenSDK;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.nbb.opa.service.receipt.utils.KeyStoreUtil;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.springframework.util.ReflectionUtils;

public class NBBUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(NBBUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File buildPropFile(String customerId) {
        boolean isSucc;
        Properties prop = new Properties();
        String appId = RequestContextUtils.getBankParameterValue((String)"appId");
        String pubKey = KeyStoreUtil.getPubKey();
        String url = RequestContextUtils.getBankParameterValue((String)"ip");
        prop.setProperty("APP_KEY", appId);
        prop.setProperty("PUBLIC_URL", url);
        prop.setProperty("PUBLIC_KEY", pubKey);
        prop.setProperty("CONNECT_TIMEOUT", "10000");
        prop.setProperty("READ_TIMEOUT", "20000");
        String configPath = System.getProperty("user.dir") + File.separator + "BONB" + File.separator + customerId;
        File fp = FileCommonUtils.getFileByPath((String)configPath);
        if (!fp.exists() && !(isSucc = fp.mkdirs())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u51fa\u9519", (String)"NBBUtil_0", (String)"ebg-receipt-banks-nbb-opa", (Object[])new Object[0]));
        }
        File configFile = FileCommonUtils.getFileByPath((String)(configPath + File.separator + "config.properties"));
        try (FileOutputStream os = new FileOutputStream(configFile);){
            prop.store(os, "");
            File file = configFile;
            return file;
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String send(String productID, String srvID, String reqJsonStr, String from) throws Exception {
        StringBuilder rs = new StringBuilder();
        StringBuilder rp = new StringBuilder();
        rs.append(from).append(ResManager.loadKDString((String)"\u8bf7\u6c42:", (String)"NBBUtil_1", (String)"ebg-receipt-banks-nbb-opa", (Object[])new Object[0])).append(reqJsonStr);
        logger.info(rs.toString());
        String repStr = OpenSDK.send((String)productID, (String)srvID, (String)reqJsonStr);
        rp.append(from).append(ResManager.loadKDString((String)"\u54cd\u5e94:", (String)"NBBUtil_2", (String)"ebg-receipt-banks-nbb-opa", (Object[])new Object[0])).append(repStr);
        logger.info(rp.toString());
        return repStr;
    }

    public static void initSdk(String customerId) throws NoSuchFieldException, IllegalAccessException {
        Field f = OpenSDK.class.getDeclaredField("isInit");
        ReflectionUtils.makeAccessible((Field)f);
        Boolean isInit = (Boolean)f.get(OpenSDK.class);
        if (Boolean.FALSE.equals(isInit)) {
            try (FileInputStream is = new FileInputStream(NBBUtil.buildPropFile(customerId));){
                OpenSDK.init((InputStream)is, (String)KeyStoreUtil.getCustomerPK());
                return;
            }
            catch (IOException e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        ReflectionUtils.setField((Field)f, OpenSDK.class, (Object)false);
        try (FileInputStream is = new FileInputStream(NBBUtil.buildPropFile(customerId));){
            OpenSDK.init((InputStream)is, (String)KeyStoreUtil.getCustomerPK());
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String getCacheName(String accNo, LocalDate transDate) {
        String cacheName = String.format("nbb_opa_receipt_%s_%s", accNo, LocalDateUtil.formatDate((LocalDate)transDate));
        return cacheName;
    }
}

