/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crcb.dc.service.helper;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class SvsSign
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SvsSign.class);
    private static SvsSign sign = null;
    private static String dataTag = "signed_data";
    private static String sendHead = "<?xml version=\"1.0\"encoding=\"CHARSET_SIGN\"?><msg><msg_head><msg_type>0</msg_type><msg_id>1005</msg_id><msg_sn>0</msg_sn><version>1</version></msg_head>";
    private static String sendEnd = "</msg>";

    private SvsSign() {
    }

    public static synchronized SvsSign getInstance() {
        if (sign == null) {
            sign = new SvsSign();
        }
        return sign;
    }

    public String signData(String oriData) throws UnsupportedEncodingException {
        String reqcharset = RequestContextUtils.getBankParameterValue((String)"charset");
        oriData = SvsSign.composeData(oriData, reqcharset);
        String signData = this.comm4Sign(oriData);
        return signData;
    }

    public static String composeData(String oriData, String reqcharset) throws UnsupportedEncodingException {
        return sendHead.replace("CHARSET_SIGN", reqcharset) + "<msg_body><origin_data_len>" + oriData.getBytes(reqcharset).length + "</origin_data_len><origin_data>" + oriData + "</origin_data></msg_body>" + sendEnd;
    }

    private String comm4Sign(String rqstStr) {
        try {
            SvsSign svsSign = new SvsSign();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(rqstStr).build();
            HashMap stringStringMap = Maps.newHashMapWithExpectedSize((int)16);
            stringStringMap.put("requestStr", rqstStr);
            EBContext.getContext().setRunningParams((Map)stringStringMap);
            BankReceiptResponseEB bankReceiptResponseEB = svsSign.doBiz(bankReceiptRequest);
            return (String)bankReceiptResponseEB.getData();
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String requestStr = bankReceiptRequest.getRequestStr();
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String signData) {
        String srcData = "-1";
        if (!StringUtils.isEmpty((String)signData)) {
            try {
                srcData = signData.substring(signData.indexOf("<" + dataTag + ">") + dataTag.length() + 2, signData.indexOf("</" + dataTag + ">"));
            }
            catch (Exception e) {
                logger.info("signData---error---Exception:" + e.getMessage(), (Object)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u83b7\u53d6\u7b7e\u540d\u7ed3\u679c\u6807\u7b7esigned_data\u4e3a\u7a7a\u3002", (String)"SvsSign_0", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
            }
            srcData = srcData.replaceAll("\r\n", "").replaceAll("\n", "");
        }
        return BankReceiptResponseEB.success((Object)srcData);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        Map runningParams = EBContext.getContext().getRunningParams();
        String rqstStr = (String)runningParams.get("requestStr");
        String encoding = RequestContextUtils.getCharset();
        String length = "" + StringLength.getLength4DataWithEncoding((String)rqstStr, (String)encoding);
        factory.setHttpHeader("Content-Type", "INFOSEC_SIGN/1.0");
        factory.setHttpHeader("Content-Length", length);
    }
}

