/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cabc.dc.service.receipt;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.receipt.banks.cabc.dc.service.receipt.api.DownloadFileImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class CabcDcReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(CabcDcReceiptDownloadImpl.class);
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CabcDcReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        if (downloadListDetails.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"CabcDcReceiptDownloadImpl_0", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]));
        }
        for (DownloadListDetail detail : downloadListDetails) {
            result.addAll(this.download(detail, taskId));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u4e3a\u7a7a\u3002", (String)"CabcDcReceiptDownloadImpl_1", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, long taskId) {
        DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        DownloadListTask task = downloadTaskService.findById(taskId);
        String fileurl = detail.getFileLink();
        String zipFileName = detail.getFileName();
        String tempPath = FileStorageUtil.getFileBakPath((String)"CABC_DC");
        String filePath = tempPath + File.separator + zipFileName;
        File zipFile = FileCommonUtils.getFileByPath((String)filePath);
        if (!zipFile.exists()) {
            HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
            runningParams.put("url", fileurl);
            runningParams.put("fileName", zipFileName);
            runningParams.put("savePath", filePath);
            EBContext.getContext().setRunningParams((Map)runningParams);
            DownloadFileImpl downloadFile = new DownloadFileImpl();
            BankReceiptRequest downloadBankReceiptRequest = BankReceiptRequest.builder().accNo(detail.getAccNo()).transDate(detail.getTransDate()).build();
            downloadFile.doBiz((BankRequest)downloadBankReceiptRequest);
        }
        List<DownloadListDetail> result = this.getDetailList(task, zipFileName);
        return result;
    }

    private List<DownloadListDetail> getDetailList(DownloadListTask task, String zipFileName) {
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>();
        String accNo = task.getAccNo();
        String transDate = task.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String tempPath = FileStorageUtil.getFileBakPath((String)"CABC_DC");
        List fileList = FileCommonUtils.readZipFiles((String)(tempPath + File.separator + zipFileName));
        if (fileList.size() == 0) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u538b\u7f29\u5305%s\u5185\u56de\u5355\u6587\u4ef6\u4e3a\u7a7a\u3002", (String)"CabcDcReceiptDownloadImpl_5", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]), zipFileName));
        }
        if (GZFileUtils.unZipFiles((String)(tempPath + File.separator + zipFileName), (String)tempPath)) {
            log.info("\u89e3\u538b\u5b8c\u6bd5...");
            for (String receiptName : fileList) {
                String serialNum = receiptName.split("_")[0];
                String newFileName = accNo + "_" + transDate + "_" + serialNum + ".pdf";
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileLink(receiptName);
                detail.setFileName(newFileName);
                detail.setTransDate(task.getTransDate());
                detailList.add(detail);
            }
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u538b\u7f29\u5305%s\u89e3\u538b\u5931\u8d25", (String)"CabcDcReceiptDownloadImpl_6", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]), zipFileName));
        }
        return detailList;
    }
}

