/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bbgb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.bbgb.dc.BBGBMetaDataImpl;
import kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.helper.Packer;
import kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.helper.SecurityUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractProxyReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReceiptDownloadImpl
extends AbstractProxyReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/ebank-other/down_task/getDownLoadFile.do");
        factory.setHttpHeader("Content-Type", "application/json");
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String fileFlowNo = bankReceiptRequest.getRequestStr();
        String jsonString = Packer.packDownLoad(fileFlowNo).toJSONString();
        String sign = SecurityUtil.getInstance().getSign(jsonString);
        String encry = SecurityUtil.getInstance().getEncry(jsonString);
        JSONObject detail = new JSONObject();
        detail.put("signData", (Object)sign);
        detail.put("ciphertext", (Object)encry);
        detail.put("bankCertSN", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.bankPublicSN));
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return detail.toJSONString();
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        return BankReceiptResponseEB.success();
    }

    public String recv(InputStream inputStream) {
        String savePath = RequestContextUtils.getRunningParam((String)"savePath");
        String fileName = RequestContextUtils.getRunningParam((String)"fileName");
        try {
            byte[] getData = this.readInputStream(inputStream);
            String string = new String(getData);
            if (string.length() < 1000) {
                logger.info("\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)string);
            }
            if (EBGStringUtils.isEmpty((String)string)) {
                throw new ReceiptException(ResManager.loadKDString((String)"downEleBillPDF\u63a5\u53e3\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-bbgb-dc", (Object[])new Object[0]));
            }
            File saveDir = FileCommonUtils.getFileByPath((String)savePath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File file = FileCommonUtils.getFileByPath((String)(saveDir + File.separator + fileName));
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(getData);
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        return "";
    }

    private byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "downEleBillPDF";
    }

    public String getBizDesc() {
        return "";
    }
}

