/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bbgb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.bbgb.dc.BBGBMetaDataImpl;
import kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.helper.Packer;
import kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.helper.SecurityUtil;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.model.DetailInfo;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/ebank-customer/accountDetailQuery/accountTranHistQuery.do");
        factory.setHttpHeader("Content-Type", "application/json");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String currentPage = this.getCurrentPage();
        String jsonString = Packer.packDetail(bankDetailRequest, currentPage).toJSONString();
        String sign = SecurityUtil.getInstance().getSign(jsonString);
        String encry = SecurityUtil.getInstance().getEncry(jsonString);
        JSONObject detail = new JSONObject();
        detail.put("signData", (Object)sign);
        detail.put("ciphertext", (Object)encry);
        detail.put("bankCertSN", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.bankPublicSN));
        return detail.toJSONString();
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String currentPage = this.getCurrentPage();
        int nextPage = Integer.parseInt(currentPage) + 100;
        this.setCurrentPage(String.valueOf(nextPage));
        JSONObject response = JSONObject.parseObject((String)s);
        String sys_code = response.getString("sys_code");
        String sys_msg = response.getString("sys_msg");
        if (!"0".equalsIgnoreCase(sys_code)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-receipt-banks-bbgb-dc", (Object[])new Object[0]), sys_code, sys_msg));
        }
        String data = response.getString("data");
        String decry = SecurityUtil.getInstance().getDecry(data);
        JSONObject detailJson = JSONObject.parseObject((String)decry);
        String ec = detailJson.getString("ec");
        String em = detailJson.getString("em");
        if (!"0".equalsIgnoreCase(ec)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-receipt-banks-bbgb-dc", (Object[])new Object[0]), ec, em));
        }
        JSONObject details = detailJson.getJSONObject("data");
        String turnPageTotalNum = details.getString("turnPageTotalNum");
        if (nextPage >= Integer.parseInt(turnPageTotalNum)) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
        }
        JSONArray jsonArray = details.getJSONArray("iTranHistInfoCopy");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        for (int j = 0; j < jsonArray.size(); ++j) {
            JSONObject detail = jsonArray.getJSONObject(j);
            String othBankName = detail.getString("othBankName");
            String othBaseAcctNo = detail.getString("othBaseAcctNo");
            String othAcctDesc = detail.getString("othAcctDesc");
            String reference = detail.getString("reference");
            String rateSeqNo = detail.getString("rateSeqNo");
            String tranAmt = detail.getString("tranAmt");
            DetailInfo info = new DetailInfo();
            info.setOppAccNo(othBaseAcctNo);
            info.setOppAccName(othAcctDesc);
            info.setOppBankName(othBankName);
            info.setReceiptNo(reference);
            info.setExplanation(rateSeqNo);
            info.setReversed1(tranAmt);
            detailList.add(info);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public List<DetailInfo> queryTransDetail(String accNo, LocalDate transDate) {
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        BankDetailRequest bankDetailRequest = new BankDetailRequest();
        bankDetailRequest.setStartDate(transDate);
        bankDetailRequest.setEndDate(transDate);
        bankDetailRequest.setHeader(header);
        this.setCurrentPage("0");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(bankDetailRequest);
            List receiveItems = response.getDetails();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }
}

