/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.helper;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.receipt.banks.bbgb.dc.BBGBMetaDataImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;

public class Packer {
    public static final int pageSize = 100;

    public static JSONObject createHeader() {
        JSONObject header = new JSONObject();
        header.put("seqNo", (Object)Sequence.gen18Sequence());
        header.put("tranDate", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        header.put("customerId", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.customNo));
        header.put("userId", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.userId));
        return header;
    }

    public static JSONObject packDetail(BankDetailRequest bankDetailRequest, String pageTag) {
        JSONObject header = Packer.createHeader();
        JSONObject body = new JSONObject();
        body.put("accountNo", (Object)bankDetailRequest.getAcnt().getAccNo());
        body.put("startDate", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("endDate", (Object)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("turnPageBeginPos", (Object)pageTag);
        body.put("turnPageShowNum", (Object)String.valueOf(100));
        body.put("tranKind", (Object)"A");
        body.put("histKind", (Object)"0");
        JSONObject detailJson = new JSONObject();
        detailJson.put("SYS_HEAD", (Object)header);
        detailJson.put("BODY", (Object)body);
        return detailJson;
    }

    public static JSONObject packDownEleBillPDF(String hostFlowNo, String bankSeqNo) {
        JSONObject header = Packer.createHeader();
        JSONObject body = new JSONObject();
        body.put("hostFlowNo", (Object)hostFlowNo);
        body.put("bankSeqNo", (Object)bankSeqNo);
        JSONObject detailJson = new JSONObject();
        detailJson.put("SYS_HEAD", (Object)header);
        detailJson.put("BODY", (Object)body);
        return detailJson;
    }

    public static JSONObject packDownLoad(String fileFlowNo) {
        JSONObject header = Packer.createHeader();
        JSONObject body = new JSONObject();
        body.put("fileFlowNo", (Object)fileFlowNo);
        JSONObject detailJson = new JSONObject();
        detailJson.put("SYS_HEAD", (Object)header);
        detailJson.put("BODY", (Object)body);
        return detailJson;
    }
}

