/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bbgb.dc.service.receipt.fetch;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.BankReceiptCreateImpl;
import kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.BankReceiptDownloadImpl;
import kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.DetailImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"BBGB_DC", (String)accNo, (String)transDateStr);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        DetailImpl detailImpl = new DetailImpl();
        List<DetailInfo> queryTransDetail = detailImpl.queryTransDetail(accNo, transDate);
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(request.getTransDate()).accNo(request.getAccNo()).build();
        if (queryTransDetail.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bbgb-dc", (Object[])new Object[0]));
        }
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existReceiptMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            existReceiptMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        for (DetailInfo detailInfo : queryTransDetail) {
            String hostFlowNo = detailInfo.getReceiptNo();
            String bankSeqNo = detailInfo.getExplanation();
            String amount = detailInfo.getReversed1();
            String oppAccNo = detailInfo.getOppAccNo();
            if (EBGStringUtils.isEmpty((String)oppAccNo)) {
                oppAccNo = "e";
            }
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            StringBuilder fileName = new StringBuilder();
            fileName.append(accNo).append("_");
            fileName.append(transDateStr).append("_");
            fileName.append(hostFlowNo).append("_");
            fileName.append(bankSeqNo).append("_");
            fileName.append(amount).append("_");
            fileName.append(oppAccNo).append("_");
            fileName.append(".pdf");
            String receiptName = fileName.toString();
            boolean isNeedDownload = true;
            if (existReceiptMap.containsKey(receiptName)) {
                downloadListDetail = (DownloadListDetail)existReceiptMap.get(receiptName);
                if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId() && downloadListDetail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId()) {
                    isNeedDownload = false;
                }
            } else {
                downloadListDetail.setFileLink(fileName.toString());
                downloadListDetail.setFileName(fileName.toString());
            }
            if (isNeedDownload) {
                BankReceiptCreateImpl bankReceiptCreate = new BankReceiptCreateImpl();
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
                paramMap.put("hostFlowNo", hostFlowNo);
                paramMap.put("bankSeqNo", bankSeqNo);
                bankReceiptRequest.setParamsMap((Map)paramMap);
                BankReceiptResponseEB bankReceiptResponseEB = bankReceiptCreate.doBiz(bankReceiptRequest);
                String fileFlowNo = (String)bankReceiptResponseEB.getData();
                BankReceiptRequest downloadRequest = BankReceiptRequest.builder().transDate(request.getTransDate()).accNo(request.getAccNo()).requestStr(fileFlowNo).build();
                BankReceiptDownloadImpl bankReceiptDownload = new BankReceiptDownloadImpl();
                RequestContextUtils.setRunningParam((String)"fileName", (String)downloadListDetail.getFileName());
                RequestContextUtils.setRunningParam((String)"savePath", (String)bakFilePath);
                BankReceiptResponseEB downloadResponse = bankReceiptDownload.doBiz(downloadRequest);
                String string = (String)downloadResponse.getData();
            }
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }
}

