/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gyb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gyb.dc.service.receipt.utils.GYB_Packer;
import kd.ebg.receipt.banks.gyb.dc.service.receipt.utils.GYB_Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class BankReceiptQueryImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptQueryImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2eQueryReceipt4UTF8";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/New_B2E/Forward.do?SIGDATA=1&";
        try {
            s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userCif");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7528\u6237\u5bc6\u7801\u5f02\u5e38", (Throwable)e);
        }
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String pack(BankDetailRequest request) {
        Element ebank_root = new Element("transaction");
        String accNo = request.getAcnt().getAccNo();
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage)) {
            currentPage = "1";
            this.setCurrentPage(currentPage);
        }
        JDomUtils.addChild((Element)ebank_root, (Element)GYB_Packer.buildHead(this.getBizCode(), Sequence.gen18Sequence()));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getDetailRequestBody(request, currentPage, "20"));
        String rqstStr = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return rqstStr;
    }

    private Element getDetailRequestBody(BankDetailRequest request, String pageTag, String page) {
        Element RequestBody = new Element("RequestBody");
        Element body = JDomUtils.addChild((Element)RequestBody, (String)"RequestRecord");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"QueryNo", (String)page);
        JDomUtils.addChild((Element)body, (String)"PageNo", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"BizType", (String)"HDZHZZ");
        return RequestBody;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        return new EBBankDetailResponse(this.parseDetail(bankDetailRequest, responseStr));
    }

    public List<DetailInfo> parseDetail(BankDetailRequest bankDetailRequest, String responseStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>();
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse bankResponse = GYB_Parser.parserCommonInfo(ebenk);
        this.setLastPage(this.isLastPage(responseStr));
        this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
        Element body = ebenk.getChild("RespondBody");
        if ("RET2003".equals(bankResponse.getResponseCode())) {
            return detailList;
        }
        if ("0000".equals(bankResponse.getResponseCode()) || "RET2000".equals(bankResponse.getResponseCode())) {
            List list = body.getChildren("RespondRecord");
            if (list.size() == 0) {
                return detailList;
            }
            for (int i = 0; i < list.size(); ++i) {
                DetailInfo detail = new DetailInfo();
                Element row = (Element)list.get(i);
                detail.setCurrency("CNY");
                String ReceiptNo = row.getChildTextTrim("ReceiptNo");
                String Amount = row.getChildTextTrim("Amount");
                String AcctNo = row.getChildTextTrim("AcctNo");
                String PayeeAcctNo = row.getChildTextTrim("PayeeAcctNo");
                String HostJournalNo = row.getChildTextTrim("HostJournalNo");
                String BEIZHU = row.getChildTextTrim("BEIZHU");
                String RecptPymtFlag = row.getChildTextTrim("RecptPymtFlag");
                detail.setAccNo(acnt.getAccNo());
                detail.setAccName(acnt.getAccName());
                if (Objects.equals(AcctNo, acnt.getAccNo())) {
                    detail.setOppAccNo(PayeeAcctNo);
                } else {
                    detail.setOppAccNo(AcctNo);
                }
                detail.setExplanation(RecptPymtFlag);
                detail.setReversed1(Amount);
                detail.setReversed2(HostJournalNo);
                detail.setReversed3(BEIZHU);
                detail.setReceiptNo(ReceiptNo);
                detailList.add(detail);
            }
        } else {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%1$s\u3002", (String)"BankReceiptQueryImpl_0", (String)"ebg-receipt-banks-gyb-dc", (Object[])new Object[0]), body.getChildText("respondInfo"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        return detailList;
    }

    public boolean isLastPage(String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element Body = root.getChild("RespondBody");
        BankResponse bankResponse = GYB_Parser.parserCommonInfo(root);
        if ("RET2003".equals(bankResponse.getResponseCode())) {
            return true;
        }
        List rowList = Body.getChildren("RespondRecord");
        return rowList == null || rowList.size() < 20;
    }

    public List<DetailInfo> queryTransDetail(String accNo, LocalDate startDate, LocalDate endDate) {
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        BankDetailRequest bankDetailRequest = new BankDetailRequest();
        bankDetailRequest.setStartDate(startDate);
        bankDetailRequest.setEndDate(endDate);
        bankDetailRequest.setHeader(header);
        this.setCurrentPage("0");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(bankDetailRequest);
            List receiveItems = response.getDetails();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }
}

