/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gyb.dc.service.receipt.download;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.receipt.banks.gyb.dc.service.receipt.api.OneReceiptDownloadImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import sun.misc.BASE64Decoder;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.DOWNLOADING.getId()) {
            return false;
        }
        return RequestContextUtils.receiptFormatIsFile() || FileCommonUtils.isTestEnv();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String accNo = request.getAccNo();
        String transDateStr = request.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate transDate = request.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        OneReceiptDownloadImpl bankReceiptDownload = new OneReceiptDownloadImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            String fileName = downloadListDetail.getFileName();
            String fileLink = downloadListDetail.getFileLink();
            if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                result.add(downloadListDetail);
                continue;
            }
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)fileLink);
                String receiptNo = jsonObject.getString("receiptNo");
                bankReceiptRequest.setRequestStr(receiptNo);
                BankReceiptResponseEB receiptResponseEB = bankReceiptDownload.doBiz(bankReceiptRequest);
                String base64Str = (String)receiptResponseEB.getData();
                this.base64ToFile(base64Str, bakFilePath, fileName);
                String receiptMatchNo = MatchRule.getInstance().getReceiptMatchNo(accNo, transDateStr, jsonObject.toJSONString());
                downloadListDetail.setReceiptJson(jsonObject.toJSONString());
                downloadListDetail.setDetailNo(receiptMatchNo);
                result.add(downloadListDetail);
            }
            catch (Throwable e) {
                logger.error("\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a{}" + e.getMessage(), e);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public void base64ToFile(String base64Str, String bakFilePath, String fileName) throws IOException {
        File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
        if (!file.exists()) {
            boolean isCreate = file.createNewFile();
            logger.info("\u521b\u5efa\u6587\u4ef6\uff1a{}\uff0c\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{file.getName(), isCreate});
        }
        byte[] bytes = new BASE64Decoder().decodeBuffer(base64Str);
        try (FileOutputStream out = new FileOutputStream(file);
             ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            byte[] buffer = new byte[1024];
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            out.flush();
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

