/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zsb.opa.service.receipt.api;

import com.alibaba.fastjson.JSON;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.zsb.opa.utils.SdkInit;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class GetBankReceiptFileName
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(GetBankReceiptFileName.class);

    public BankReceiptResponseEB doBiz(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        String serialNo = request.getRequestStr();
        return BankReceiptResponseEB.success((Object)this.processDetail(accNo, transDateStr, serialNo));
    }

    private String processDetail(String accNo, String transDateStr, String serialNo) {
        SdkInit.init();
        ApiHeader header = new ApiHeader();
        header.setMsgtype("yqwfw_qryReceiptInfo");
        header.setTraceno(Sequence.genSequence());
        HashMap<String, String> body = new HashMap<String, String>(5);
        body.put("accNo", accNo);
        body.put("serialNo", serialNo);
        this.logger.info("\u6d59\u5546sdk\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570:{}", body);
        String rsp = "";
        try {
            ApiRspData data = ServiceBean.getService().invoke(header, body);
            rsp = JSON.toJSONString((Object)data);
            this.logger.info("\u6d59\u5546yqwfw_qryReceiptInfo\u8bf7\u6c42-{}-{}-\u6d41\u6c34\u53f7\uff1a{}-\u8fd4\u56de\u62a5\u6587\uff1a{}", new Object[]{accNo, transDateStr, serialNo, rsp});
            String code = data.getResultcode();
            String desc = data.getResultdesc();
            if (!code.equals("000000")) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6d59\u5546\u65e0\u524d\u7f6e\u673a\u7248\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u7801 = %1$s\uff0c\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u94f6\u884c\u63cf\u8ff0 = %2$s\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u3002", (String)"GetBankReceiptFileName_3", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]), code, desc));
            }
            Map rspBody = data.getBody();
            String receiptFileName = rspBody.get("receiptFileName").toString();
            this.logger.info("\u6d59\u5546yqwfw_qryReceiptInfo\u8bf7\u6c42-{}-{}-\u6d41\u6c34\u53f7\uff1a{}-\u8fd4\u56dereceiptFileName = {}", new Object[]{accNo, transDateStr, serialNo, receiptFileName});
            return receiptFileName;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u94f6\u884cSDK\u5931\u8d25", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8c03\u7528\u94f6\u884cSDK\u5931\u8d25", (String)"GetBankReceiptFileName_1", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        return null;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "yqwfw_qryReceiptInfo";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u67e5\u8be2", (String)"GetBankReceiptFileName_2", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]);
    }
}

