/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zsb.opa.utils;

import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.config.EntAppConfig;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.receipt.banks.zsb.opa.ZsbOpaMetaDataImpl;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.CertInfo;
import kd.ebg.receipt.common.model.repository.UserCertRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.commons.codec.binary.Base64;

public class SdkInit {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SdkInit.class);

    public static String getURL() {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        if (EBGStringUtils.isNotEmpty((String)port)) {
            String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
            port = "HTTPS".equals(protocol) && "443".equals(port) ? "" : ("HTTP".equals(protocol) && "80".equals(port) ? "" : ":" + port);
            return protocol + "://" + ip + port + RequestContextUtils.getBankParameterValue((String)"exchangeUri") + "/";
        }
        if (EBGStringUtils.isEmpty((String)ip)) {
            return RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.baseurl);
        }
        return ip;
    }

    public static String getFileURL() {
        String ip = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.fileurl);
        String port = RequestContextUtils.getBankParameterValue((String)"filePort");
        if (EBGStringUtils.isNotEmpty((String)port)) {
            String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
            port = "HTTPS".equals(protocol) && "443".equals(port) ? "" : ("HTTP".equals(protocol) && "80".equals(port) ? "" : ":" + port);
            return protocol + "://" + ip + port + RequestContextUtils.getBankParameterValue((String)"file_uri") + "/";
        }
        return ip;
    }

    public static void init() {
        EntAppConfig config = new EntAppConfig();
        String openid = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.openid);
        config.setOpenid(openid);
        String appid = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.appid);
        config.setAppid(appid);
        String appkey = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.appkey);
        config.setAppkey(appkey);
        String baseurl = SdkInit.getURL();
        config.setBaseurl(baseurl);
        String fileurl = SdkInit.getFileURL();
        config.setFileurl(fileurl);
        try {
            config.setCfcafile(SdkInit.getCfcaKey());
            String pwd = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.cfcaAcnum);
            config.setCfcapwd(pwd);
            config.setCerfile(SdkInit.getCerKey());
            ServiceBean.getService((EntAppConfig)config);
            logger.info("\u6d59\u5546sdk\u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Throwable e) {
            logger.error("\u53c2\u6570\u521d\u59cb\u5316\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d59\u5546sdk\u53c2\u6570\u521d\u59cb\u5316\u5f02\u5e38\uff1a%s\u3002", (String)"SdkInit_3", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static byte[] getCfcaKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(ZsbOpaMetaDataImpl.cfcafile, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u524d\u7f6e\u673a\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u79c1\u94a5\u8bc1\u4e66\u3002", (String)"SdkInit_1", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = SdkInit.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return fileContent;
    }

    public static byte[] getCerKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(ZsbOpaMetaDataImpl.cerfile, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u516c\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u524d\u7f6e\u673a\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u516c\u94a5\u8bc1\u4e66\u3002", (String)"SdkInit_2", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = SdkInit.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return fileContent;
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }
}

