/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.psdc.dc.service.receipt;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.psdc.dc.service.receipt.PsbcDcCommConfig;
import kd.ebg.receipt.banks.psdc.dc.service.receipt.util.RequestPacker;
import kd.ebg.receipt.banks.psdc.dc.service.receipt.util.ResponseParser;
import kd.ebg.receipt.banks.psdc.dc.service.receipt.util.SocketSender;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        String detailResponse;
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = task.getAccNo();
        String TransDate = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String queryDate = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        String bankLoginId = bankReceiptHandleRequest.getBankLoginId();
        PsbcDcCommConfig config = (PsbcDcCommConfig)EBConfigBuilder.getInstance().buildConfig(PsbcDcCommConfig.class, bankLoginId);
        int pageNo = 0;
        int pageNum = 300;
        ArrayList<String> EnterpriseID_list = new ArrayList<String>(1);
        do {
            String detailRequest = RequestPacker.detailtPack(config.getOutsys_Code(), config.getGroupNo(), queryDate, accNo, TransDate, String.valueOf(pageNo), pageNum);
            detailResponse = SocketSender.sendRequest(detailRequest, bankLoginId, "GBK");
            EnterpriseID_list.addAll(ResponseParser.detailPageParser(detailResponse));
            pageNo += pageNum;
        } while (!"-1".equals(ResponseParser.hasNextPage(detailResponse)));
        for (String EnterpriseID : EnterpriseID_list) {
            String request = RequestPacker.receiptPack(config.getOutsys_Code(), config.getGroupNo(), queryDate, accNo, TransDate, EnterpriseID);
            logger.info("\u90ae\u50a8\u94f6\u884c\u67e5\u8be2\u56de\u5355\u8bf7\u6c42\uff1a\n{}", (Object)request);
            String response = SocketSender.sendRequest(request, task.getBankLoginId(), "GBK");
            logger.info("\u90ae\u50a8\u94f6\u884c\u67e5\u8be2\u56de\u5355\u54cd\u5e94\uff1a\n{}", (Object)response);
            String PDFName = ResponseParser.receipt2070Parser(response);
            StringBuilder builder = new StringBuilder();
            builder.append(accNo).append("-").append(TransDate).append("-").append(EnterpriseID).append(".").append("pdf");
            String newFileName = builder.toString();
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(PDFName);
            detail.setFileName(newFileName);
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u5df2\u4e0b\u8f7d\u6210\u529f\uff0c\u5c06\u4e0d\u518d\u91cd\u590d\u4e0b\u8f7d\uff08\u8bf7\u68c0\u67e5\u5907\u4efd\u76ee\u5f55\uff09\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-psbc-dc", (Object[])new Object[0]));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_3", (String)"ebg-receipt-banks-psbc-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PSBC_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u90ae\u50a8\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-psbc-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

