/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.psdc.dc.service.receipt.util;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.psdc.dc.service.receipt.util.PsbcSocketUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class SocketSender
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(SocketSender.class);

    public static String sendRequest(String str, String bankLoginId, String encode) {
        SocketSender socketSender = new SocketSender();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(str).build();
        BankReceiptResponseEB receiptResponseEB = socketSender.doBiz(bankReceiptRequest);
        return (String)receiptResponseEB.getData();
    }

    public String recv(InputStream inputStream) {
        byte[] bytes = PsbcSocketUtil.readTcpByte(inputStream, "10", RequestContextUtils.getCharset());
        String rspStr = "";
        try {
            rspStr = new String(bytes, RequestContextUtils.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6");
        }
        return rspStr;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        return bankReceiptRequest.getRequestStr();
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        return BankReceiptResponseEB.success((Object)responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

