/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.CCBDCCommConfig;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.api.BankReceiptListQueryApiImpl;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.api.BankReceiptNameQueryApiImpl;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.api.BankReceiptOneQueryApiImpl;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.api.BankReceiptPageNumQueryApiImpl;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.api.DetailImpl;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.util.CCBDCFileParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        DownloadListDetail downloadListDetail2;
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = request.getBankLoginId();
        String customId = EBContext.getContext().getCustomID();
        logger.info("\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u5916\u8054\u7248-\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868-\u79df\u6237\u53f7-{}-\u8c03\u5ea6\u8d26\u53f7:{} bankLoginId:{}", new Object[]{customId, accNo, bankLoginId});
        ArrayList<Object> result = new ArrayList<Object>(16);
        HashMap existFileName = Maps.newHashMapWithExpectedSize((int)1);
        List listDetails = this.downloadListDetailService.selectByRefId(request.getTaskId());
        for (DownloadListDetail downloadListDetail2 : listDetails) {
            if (downloadListDetail2.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId() || downloadListDetail2.getMatchFlag().intValue() != MatchStatusEnum.SUCCESS.getId()) continue;
            existFileName.put(downloadListDetail2.getFileName(), downloadListDetail2);
        }
        CCBDCCommConfig config = (CCBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CCBDCCommConfig.class, bankLoginId);
        if (Objects.equals(config.getHistory_interface_choose(), "NWHD03")) {
            if (listDetails.size() > 0) {
                downloadListDetail2 = (DownloadListDetail)listDetails.get(0);
                CCBDCFileParser ccbdcFileParser = new CCBDCFileParser();
                ccbdcFileParser.setFileName(downloadListDetail2.getFileName());
                int length = ccbdcFileParser.getFileSplitLength();
                if (length < 6) {
                    List ids = listDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
                    this.downloadListDetailService.deleteAll(ids);
                    existFileName = Maps.newHashMapWithExpectedSize((int)1);
                }
            }
            return BankReceiptHandleResponseEB.success(this.chooseNWHD03(request, existFileName));
        }
        if (listDetails.size() > 0) {
            downloadListDetail2 = (DownloadListDetail)listDetails.get(0);
            CCBDCFileParser ccbdcFileParser = new CCBDCFileParser();
            ccbdcFileParser.setFileName(downloadListDetail2.getFileName());
            int length = ccbdcFileParser.getFileSplitLength();
            if (length == 4) {
                List ids = listDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
                this.downloadListDetailService.deleteAll(ids);
                existFileName = Maps.newHashMapWithExpectedSize((int)1);
            }
        }
        try {
            logger.info("\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u5916\u8054\u7248-\u8c03\u5ea6\u8d26\u53f7:{} \u8c03\u5ea6\u65e5\u671f\uff1a{}", new Object[]{accNo, LocalDateUtil.formatDate((LocalDate)transDate)});
            BankReceiptRequest receiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
            BankReceiptPageNumQueryApiImpl iBankReceipt = new BankReceiptPageNumQueryApiImpl();
            BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)receiptRequest);
            int pageNum = (Integer)receiptResponseEB.getData();
            String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            List returnList = new ArrayList(16);
            Map returnValue = Maps.newHashMapWithExpectedSize((int)8);
            DownloadListDetail detail = null;
            for (int i = 1; pageNum > 0 && i <= pageNum; ++i) {
                BankReceiptListQueryApiImpl bankReceiptListQueryApi = new BankReceiptListQueryApiImpl();
                HashMap map = Maps.newHashMapWithExpectedSize((int)8);
                map.put("page", i + "");
                receiptRequest.setParamsMap((Map)map);
                BankReceiptResponseEB responseEB = (BankReceiptResponseEB)bankReceiptListQueryApi.doBiz((BankRequest)receiptRequest);
                returnList = (List)responseEB.getData();
                if (returnList.size() == 0) {
                    throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff1a\u8bf7\u68c0\u67e5\u4ea4\u6613\u660e\u7ec6\uff0c\u5982\u82e5\u5b58\u5728\uff0c\u9700\u7b49\u5f85\u4efb\u52a1\u81ea\u52a8\u91cd\u8bd5\u4e0b\u8f7d\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]));
                }
                for (int k = 0; k < returnList.size(); ++k) {
                    returnValue = (Map)returnList.get(k);
                    String newFileName = accNo + "_" + date + "_" + (String)returnValue.get("LOG_NO") + "_" + (String)returnValue.get("TX_AMT") + "_" + (String)returnValue.get("INNER_NO") + ".pdf";
                    if (existFileName.containsKey(newFileName)) {
                        result.add(existFileName.get(newFileName));
                        continue;
                    }
                    BankReceiptNameQueryApiImpl bankReceiptNameQueryApi = new BankReceiptNameQueryApiImpl();
                    HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
                    paramMap.put("inner_no", returnValue.get("INNER_NO"));
                    receiptRequest.setParamsMap((Map)paramMap);
                    try {
                        BankReceiptResponseEB bankReceiptResponseEB = (BankReceiptResponseEB)bankReceiptNameQueryApi.doBiz((BankRequest)receiptRequest);
                        String filename = (String)bankReceiptResponseEB.getData();
                        detail = new DownloadListDetail();
                        detail.setFileLink(filename);
                        detail.setFileName(newFileName);
                        result.add(detail);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("\u8bf7\u6c42NWHD02\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u5916\u8054\u7248-\u83b7\u53d6\u56de\u5355\u4e0b\u8f7d\u5217\u8868\u53d1\u751f\u5f02\u5e38.", new Object[]{e.getMessage()});
            String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u4e0b\u8f7d\u5217\u8868\u53d1\u751f\u5f02\u5e38\uff1a%s", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), e.getMessage());
            throw new ReceiptException(msg, (Throwable)e);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u5916\u8054\u7248-\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> chooseNWHD03(BankReceiptHandleRequest request, Map<String, DownloadListDetail> existFileName) {
        DetailImpl detailImpl = new DetailImpl();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        List<DetailInfo> detailInfoList = detailImpl.queryReceiptList(accNo, transDate);
        if (detailInfoList.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f53\u5929\u6ca1\u6709\u4ea4\u6613", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]));
        }
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        BankReceiptOneQueryApiImpl bankReceiptOneQueryApi = new BankReceiptOneQueryApiImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        for (DetailInfo detail : detailInfoList) {
            String trxNo = detail.getBizRefNo();
            String amount = detail.getReversed1();
            String cdFlag = detail.getReversed2();
            String oppAccNo = detail.getOppAccNo();
            String newFileName = accNo + "_" + date + "_" + trxNo + "_" + amount + "_" + cdFlag + "_" + oppAccNo + ".pdf";
            if (countMap.containsKey(newFileName)) {
                int count = (Integer)countMap.get(newFileName) + 1;
                countMap.put(newFileName, count);
                newFileName = newFileName + "-" + String.format("%04d", count);
            } else {
                countMap.put(newFileName, 0);
            }
            if (existFileName.containsKey(newFileName)) {
                result.add(existFileName.get(newFileName));
                continue;
            }
            bankReceiptRequest.setRequestStr(trxNo);
            try {
                BankReceiptResponseEB receiptResponseEB = bankReceiptOneQueryApi.doBiz(bankReceiptRequest);
                String fileName = (String)receiptResponseEB.getData();
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileName(newFileName);
                downloadListDetail.setFileLink(fileName);
                result.add(downloadListDetail);
            }
            catch (Throwable e) {
                logger.monitorError("NWHD03-error" + e.getMessage(), e);
            }
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CCB_DC_RECEIPT_FETCH";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u5916\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_3", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

