/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.dc.service.receipt.api;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptListQueryApiImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptListQueryApiImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        Map paramMap = request.getParamsMap();
        String page = (String)paramMap.get("page");
        Map<String, String> params = this.getRequestParams(accNo, transDate, page, "20");
        String requestStr = this.getRequestXml(params);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String response) {
        response = response.replace("&", "&amp;");
        ArrayList mapList = new ArrayList(16);
        try {
            Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
            String returnCode = JDomExtUtils.getChildElement((Element)root, (String)"RETURN_CODE").getTextTrim();
            String returnMsg = JDomExtUtils.getChildElement((Element)root, (String)"RETURN_MSG").getTextTrim();
            if (!"000000".equals(returnCode)) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528NWHD01\u63a5\u53e3\u63a5\u6536\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u8fd4\u56de\u7801[%1$s]:%2$s\u3002", (String)"BankReceiptListQueryApiImpl_4", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), returnCode, returnMsg));
            }
            Element tx_info = JDomExtUtils.getChildElement((Element)root, (String)"TX_INFO");
            String PAGE = JDomUtils.getChildElement((Element)tx_info, (String)"PAGE").getTextTrim();
            String TOTAL_PAGE = JDomUtils.getChildElement((Element)tx_info, (String)"TOTAL_PAGE").getTextTrim();
            List elements = tx_info.getChildren("DETAILLIST");
            elements.forEach(e -> {
                HashMap map = Maps.newHashMapWithExpectedSize((int)8);
                map.put("PAGE", PAGE);
                map.put("TOTAL_PAGE", TOTAL_PAGE);
                String INNER_NO = JDomUtils.getChildElement((Element)e, (String)"INNER_NO").getTextTrim();
                String TRAN_DATE = JDomUtils.getChildElement((Element)e, (String)"TRAN_DATE").getTextTrim();
                String LOG_NO = JDomUtils.getChildElement((Element)e, (String)"LOG_NO").getTextTrim();
                String TX_AMT = JDomUtils.getChildElement((Element)e, (String)"TX_AMT").getTextTrim();
                if (StringUtils.isEmpty((String)TX_AMT)) {
                    TX_AMT = "e";
                }
                map.put("TX_AMT", TX_AMT);
                map.put("INNER_NO", INNER_NO);
                map.put("TRAN_DATE", TRAN_DATE);
                map.put("LOG_NO", LOG_NO);
                mapList.add(map);
            });
        }
        catch (Exception e2) {
            if (e2.getMessage().contains(PropertiesConstantsUtils.getValue((String)"NWHD01_ERROR_CODE"))) {
                throw new ReceiptException(e2.getMessage(), (Throwable)e2);
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"NWHD01\u83b7\u53d6\u56de\u5355\u4fe1\u606f\u5f02\u5e38\uff08\u4efb\u52a1\u5c06\u81ea\u52a8\u91cd\u8bd5\u4e0b\u8f7d\uff09\uff1a%s", (String)"BankReceiptListQueryApiImpl_5", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), response.substring(0, 160)), (Throwable)e2);
        }
        return BankReceiptResponseEB.success(mapList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CCB_DC_RECEIPT_LIST_QUERY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u5916\u8054\u7248\u83b7\u53d6\u56de\u5355\u5217\u8868\u8bf7\u6c42", (String)"BankReceiptListQueryApiImpl_3", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }

    private Map<String, String> getRequestParams(String accNo, LocalDate transDate, String page, String recordNum) {
        String STARTDATE;
        HashMap params = Maps.newHashMapWithExpectedSize((int)8);
        String ENDDATE = STARTDATE = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String PAGE = page;
        String TOTAL_RECORD = recordNum;
        params.put("ACC_NO", accNo);
        params.put("STARTDATE", STARTDATE);
        params.put("ENDDATE", ENDDATE);
        params.put("PAGE", PAGE);
        params.put("TOTAL_RECORD", TOTAL_RECORD);
        return params;
    }

    private String getRequestXml(Map<String, String> params) {
        String REQUEST_SN = Sequence.gen16NumSequence() + "";
        String CUST_ID = RequestContextUtils.getBankParameterValue((String)"CUST_ID");
        String USER_ID = RequestContextUtils.getBankParameterValue((String)"USER_ID");
        String PASSWORD = RequestContextUtils.getBankParameterValue((String)"PASSWORD");
        String TX_CODE = "NWHD01";
        String LANGUAGE = "CN";
        String ACC_NO = params.get("ACC_NO");
        String STARTDATE = params.get("STARTDATE");
        String ENDDATE = params.get("ENDDATE");
        String PAGE = params.get("PAGE");
        String TOTAL_RECORD = params.get("TOTAL_RECORD");
        Element root = JDomExtUtils.createRoot((String)"TX");
        JDomUtils.addChild((Element)root, (String)"REQUEST_SN", (String)REQUEST_SN);
        JDomUtils.addChild((Element)root, (String)"CUST_ID", (String)CUST_ID);
        JDomUtils.addChild((Element)root, (String)"USER_ID", (String)USER_ID);
        JDomUtils.addChild((Element)root, (String)"PASSWORD", (String)PASSWORD);
        JDomUtils.addChild((Element)root, (String)"TX_CODE", (String)TX_CODE);
        JDomUtils.addChild((Element)root, (String)"LANGUAGE", (String)LANGUAGE);
        Element body = JDomUtils.addChild((Element)root, (String)"TX_INFO");
        JDomUtils.addChild((Element)body, (String)"ACC_NO", (String)ACC_NO);
        JDomUtils.addChild((Element)body, (String)"STARTDATE", (String)STARTDATE);
        JDomUtils.addChild((Element)body, (String)"ENDDATE", (String)ENDDATE);
        JDomUtils.addChild((Element)body, (String)"PAGE", (String)PAGE);
        JDomUtils.addChild((Element)body, (String)"TOTAL_RECORD", (String)TOTAL_RECORD);
        return JDomExtUtils.doc2StrGB18030((Document)new Document(root));
    }
}

