/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.dc.service.receipt.api;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptNameQueryApiImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptNameQueryApiImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        Map paramMap = request.getParamsMap();
        String innerNo = (String)paramMap.get("inner_no");
        String requestStr = this.getFileRequestXml(accNo, innerNo);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String response) {
        String filename = "";
        try {
            filename = this.parseFileRequest(response);
        }
        catch (Exception e) {
            if (e.getMessage().contains(PropertiesConstantsUtils.getValue((String)"NWHD01_ERROR_CODE"))) {
                throw new ReceiptException(e.getMessage(), (Throwable)e);
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"NWHD01\u83b7\u53d6\u56de\u5355\u4fe1\u606f\u5f02\u5e38\uff08\u4efb\u52a1\u5c06\u81ea\u52a8\u91cd\u8bd5\u4e0b\u8f7d\uff09\uff1a%s\u3002", (String)"BankReceiptNameQueryApiImpl_5", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), response.substring(0, 160)), (Throwable)e);
        }
        return BankReceiptResponseEB.success((Object)filename);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CCB_DC_RECEIPT_NAME_QUERY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u5916\u8054\u7248\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u540d\u8bf7\u6c42\u3002", (String)"BankReceiptNameQueryApiImpl_2", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }

    private String getFileRequestXml(String accNo, String innerNo) {
        String REQUEST_SN = Sequence.gen16NumSequence() + "";
        String CUST_ID = RequestContextUtils.getBankParameterValue((String)"CUST_ID");
        String USER_ID = RequestContextUtils.getBankParameterValue((String)"USER_ID");
        String PASSWORD = RequestContextUtils.getBankParameterValue((String)"PASSWORD");
        String TX_CODE = "NWHD02";
        String LANGUAGE = "CN";
        Element root = JDomExtUtils.createRoot((String)"TX");
        JDomUtils.addChild((Element)root, (String)"REQUEST_SN", (String)REQUEST_SN);
        JDomUtils.addChild((Element)root, (String)"CUST_ID", (String)CUST_ID);
        JDomUtils.addChild((Element)root, (String)"USER_ID", (String)USER_ID);
        JDomUtils.addChild((Element)root, (String)"PASSWORD", (String)PASSWORD);
        JDomUtils.addChild((Element)root, (String)"TX_CODE", (String)TX_CODE);
        JDomUtils.addChild((Element)root, (String)"LANGUAGE", (String)LANGUAGE);
        Element body = JDomUtils.addChild((Element)root, (String)"TX_INFO");
        JDomUtils.addChild((Element)body, (String)"ACC_NO", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"DOWNLOAD_NOS", (String)innerNo);
        String content = JDomExtUtils.doc2StrGB18030((Document)new Document(root));
        return content;
    }

    private String parseFileRequest(String response) {
        String fileName = "";
        Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
        Element tx_info = JDomExtUtils.getChildElement((Element)root, (String)"TX_INFO");
        String returnCode = JDomUtils.getChildElement((Element)root, (String)"RETURN_CODE").getTextTrim();
        String returnMsg = JDomExtUtils.getChildElement((Element)root, (String)"RETURN_MSG").getTextTrim();
        if (!"000000".equals(returnCode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528NWHD02\u63a5\u53e3\u63a5\u6536\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u8fd4\u56de\u7801[%1$s]\uff1a%2$s\u3002", (String)"BankReceiptNameQueryApiImpl_6", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), returnCode, returnMsg));
        }
        String FILE_SUCCESS = JDomUtils.getChildElement((Element)tx_info, (String)"FILE_SUCCESS").getTextTrim();
        if (!"0".equalsIgnoreCase(FILE_SUCCESS)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"NWHD02\u67e5\u8be2\u56de\u5355\u6587\u4ef6\u5931\u8d25\uff1a%s\u3002", (String)"BankReceiptNameQueryApiImpl_7", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), response));
        }
        fileName = JDomUtils.getChildElement((Element)tx_info, (String)"FILE_NAME").getTextTrim();
        return fileName;
    }
}

