/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.dc.service.receipt.api;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptOneQueryApiImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptOneQueryApiImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String logNo = request.getRequestStr();
        Map<String, String> params = this.getRequestParams(accNo, transDate, logNo);
        String requestStr = this.getRequestXml(params);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String response) {
        response = response.replace("&", "&amp;");
        Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
        String returnCode = JDomExtUtils.getChildElement((Element)root, (String)"RETURN_CODE").getTextTrim();
        String returnMsg = JDomExtUtils.getChildElement((Element)root, (String)"RETURN_MSG").getTextTrim();
        if (!"000000".equals(returnCode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528NWHD03\u63a5\u53e3\u63a5\u6536\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u8fd4\u56de\u7801[%1$s]\uff1a%2$s", (String)"BankReceiptOneQueryApiImpl_0", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), returnCode, returnMsg));
        }
        Element tx_info = JDomExtUtils.getChildElement((Element)root, (String)"TX_INFO");
        String FILE_SUCCESS = JDomUtils.getChildElement((Element)tx_info, (String)"FILE_SUCCESS").getTextTrim();
        String FILE_NAME = JDomUtils.getChildElement((Element)tx_info, (String)"FILE_NAME").getTextTrim();
        if (Objects.equals(FILE_SUCCESS, "0")) {
            return BankReceiptResponseEB.success((Object)FILE_NAME);
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528NWHD03\u63a5\u53e3\u63a5\u6536\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u8fd4\u56de\u7801[%1$s]\uff1a%2$s", (String)"BankReceiptOneQueryApiImpl_0", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), returnCode, returnMsg));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "NWHD03";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }

    private Map<String, String> getRequestParams(String accNo, LocalDate transDate, String logNo) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)8);
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        params.put("ACC_NO", accNo);
        params.put("TRAN_DATE", transDateStr);
        params.put("TX_LOG_NO", logNo);
        return params;
    }

    private String getRequestXml(Map<String, String> params) {
        String CUST_ID = RequestContextUtils.getBankParameterValue((String)"CUST_ID");
        String USER_ID = RequestContextUtils.getBankParameterValue((String)"USER_ID");
        String PASSWORD = RequestContextUtils.getBankParameterValue((String)"PASSWORD");
        String REQUEST_SN = Sequence.gen16NumSequence() + "";
        String TX_CODE = "NWHD03";
        String LANGUAGE = "CN";
        String ACC_NO = params.get("ACC_NO");
        String TRAN_DATE = params.get("TRAN_DATE");
        String TX_LOG_NO = params.get("TX_LOG_NO");
        Element root = JDomExtUtils.createRoot((String)"TX");
        JDomUtils.addChild((Element)root, (String)"REQUEST_SN", (String)REQUEST_SN);
        JDomUtils.addChild((Element)root, (String)"CUST_ID", (String)CUST_ID);
        JDomUtils.addChild((Element)root, (String)"USER_ID", (String)USER_ID);
        JDomUtils.addChild((Element)root, (String)"PASSWORD", (String)PASSWORD);
        JDomUtils.addChild((Element)root, (String)"TX_CODE", (String)TX_CODE);
        JDomUtils.addChild((Element)root, (String)"LANGUAGE", (String)LANGUAGE);
        Element body = JDomUtils.addChild((Element)root, (String)"TX_INFO");
        JDomUtils.addChild((Element)body, (String)"ACC_NO", (String)ACC_NO);
        JDomUtils.addChild((Element)body, (String)"TX_LOG_NO", (String)TX_LOG_NO);
        JDomUtils.addChild((Element)body, (String)"TRAN_DATE", (String)TRAN_DATE);
        return JDomExtUtils.doc2StrGB18030((Document)new Document(root));
    }
}

