/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.dc.service.receipt.api;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.util.DetailPacker;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.util.DetailPage;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.util.DetailParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.model.DetailInfo;

public class DetailImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String pack(BankReceiptRequest request) {
        DetailPacker detailPacker = new DetailPacker();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String pageTag = this.getCurrentPage();
        String requestStr = detailPacker.packNormalDetail(accNo, transDateStr, pageTag);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        DetailParser parser = new DetailParser();
        List<DetailInfo> detailInfos = parser.parseDetail(responseStr);
        String pageTag = this.getCurrentPage();
        DetailPage detailPage = new DetailPage();
        pageTag = detailPage.getNextPageTag(responseStr, pageTag);
        this.setLastPage(detailPage.isLastPage(responseStr, pageTag));
        this.setCurrentPage(pageTag);
        return BankReceiptResponseEB.success(detailInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "6WY101";
    }

    public String getBizDesc() {
        return null;
    }

    public List<DetailInfo> queryReceiptList(String accNo, LocalDate transDate) {
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        boolean lastPage = false;
        this.setLastPage(false);
        DetailPage detailPage = new DetailPage();
        String pageTag = detailPage.getFirstPageTag();
        this.setCurrentPage(pageTag);
        while (!lastPage) {
            BankReceiptResponseEB response = this.doBiz(request);
            List receiveItems = (List)response.getData();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }
}

