/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.qdb.dc.service.api;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.qdb.dc.service.util.Packer;
import kd.ebg.receipt.banks.qdb.dc.service.util.Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private static final String DETAIL_CODE = "CBE022";
    private static final int PAGE_SHOW_NUM = 50;

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfoList = new ArrayList(8);
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse bizRsp = this.doBiz(request);
            detailInfoList.addAll(bizRsp.getDetails());
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getUrl());
        Packer.setContentType(factory);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        Element root = Packer.ccreateCommonHead(DETAIL_CODE);
        Element ReqParam = root.getChild("opReq").getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)ReqParam, (String)"accountType", (String)"D");
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)bankDetailRequest.getAcnt().getCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"beginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)ReqParam, (String)"endDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)ReqParam, (String)"beginAmount", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"endAmount", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageShowNum", (String)"50");
        int pagePos = Integer.parseInt(this.getCurrentPage());
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageBeginPos", (String)(pagePos * 50 + 1 + ""));
        JDomUtils.addChild((Element)ReqParam, (String)"queryFlag", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"moreRecInd", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"searchKeys", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"sqlInfo", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved2", (String)"");
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.createRequestMsg(DETAIL_CODE, xmlMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String s) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(8);
        BankAcnt acnt = request.getAcnt();
        BankResponse rsp = Parser.parseHeader(s);
        if (!"0000".equals(rsp.getResponseCode())) {
            if ("000305".equals(rsp.getResponseCode())) {
                return new EBBankDetailResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_0", (String)"ebg-receipt-banks-qdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()})));
        }
        Element root = JDomUtils.string2Root((String)Parser.getRespXml(s), (String)RequestContextUtils.getCharset());
        Element opResult = root.getChild("opRep").getChild("opResult");
        if (null == opResult) {
            return new EBBankDetailResponse(detailList);
        }
        String turnPageTotalNum = opResult.getChildTextTrim("turnPageTotalNum");
        if (!StringUtils.isEmpty((String)turnPageTotalNum)) {
            int totalNum = Integer.parseInt(turnPageTotalNum);
            if (totalNum == 0) {
                return new EBBankDetailResponse(detailList);
            }
            int pagePos = Integer.parseInt(this.getCurrentPage()) + 1;
            this.setLastPage(totalNum <= pagePos * 50);
            this.setCurrentPage(pagePos);
        }
        String moreRecInd = opResult.getChildTextTrim("moreRecInd");
        String searchKeys = opResult.getChildTextTrim("searchKeys");
        String sqlInfo = opResult.getChildTextTrim("sqlInfo");
        Element list = opResult.getChild("list");
        List rowList = list.getChildren("row");
        for (int i = 0; i < rowList.size(); ++i) {
            Element d = (Element)rowList.get(i);
            DetailInfo detailInfo = new DetailInfo();
            String oppositeAccNo = d.getChildTextTrim("oppositeAccNo");
            String transferAmt = d.getChildTextTrim("transferAmt");
            String onloanFlag = d.getChildTextTrim("onloanFlag");
            String ecTran = d.getChildTextTrim("ecTran");
            String orderFlowNo = d.getChildTextTrim("orderFlowNo");
            String subseq1 = d.getChildTextTrim("SUBSEQ1");
            String tellerID = d.getChildTextTrim("tellerID");
            String transferDate = d.getChildTextTrim("transferDate");
            String fileName = acnt.getAccNo() + "_" + oppositeAccNo + "_" + transferDate + "_" + transferAmt + "_" + onloanFlag + "_" + ecTran + "_" + orderFlowNo + "_" + subseq1 + "_" + tellerID;
            String info = moreRecInd + "_" + searchKeys + "_" + sqlInfo;
            detailInfo.setReceiptNo(fileName);
            detailInfo.setReversed2(info);
            detailList.add(detailInfo);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return DETAIL_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-receipt-banks-qdb-dc", (Object[])new Object[0]);
    }
}

