/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.qdb.dc.service.api;

import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.qdb.dc.service.util.Packer;
import kd.ebg.receipt.banks.qdb.dc.service.util.Parser;
import kd.ebg.receipt.banks.qdb.dc.service.util.ReceiptInfo;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class ReceiptRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptRequestImpl.class);
    private static final String RECEIPT_CODE = "CBE247";

    public String pack(BankReceiptRequest request) {
        Map paramsMap = request.getParamsMap();
        ReceiptInfo receiptInfo = (ReceiptInfo)paramsMap.get("receiptInfo");
        Element root = Packer.ccreateCommonHead(RECEIPT_CODE);
        Element ReqParam = root.getChild("opReq").getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)request.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)request.getAcnt().getCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"transDate", (String)request.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)ReqParam, (String)"subOrderFlowNo", (String)receiptInfo.getSubseq1());
        JDomUtils.addChild((Element)ReqParam, (String)"ecTran", (String)receiptInfo.getEcTran());
        JDomUtils.addChild((Element)ReqParam, (String)"tellerID", (String)receiptInfo.getTellerID());
        JDomUtils.addChild((Element)ReqParam, (String)"orderFlowNo", (String)receiptInfo.getOrderFlowNo());
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved2", (String)"");
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.createRequestMsg(RECEIPT_CODE, xmlMsg);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        BankResponse rsp = Parser.parseHeader(s);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u5355\u4e0b\u8f7d\u5931\u8d25 :%s\u3002", (String)"ReceiptRequestImpl_0", (String)"ebg-receipt-banks-qdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()})));
        }
        Element root = JDomUtils.string2Root((String)Parser.getRespXml(s), (String)RequestContextUtils.getCharset());
        Element opResult = root.getChild("opRep").getChild("opResult");
        String fileContent = opResult.getChildTextTrim("fileContent");
        return BankReceiptResponseEB.success((Object)fileContent);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return RECEIPT_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u7535\u5b50\u56de\u5355\u67e5\u8be2\u4e0b\u8f7d", (String)"ReceiptRequestImpl_1", (String)"ebg-receipt-banks-qdb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getUrl());
        Packer.setContentType(factory);
    }
}

