/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbcb.dc.services.receipt.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class DownloadFileImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadFileImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Map runningParams = EBContext.getContext().getRunningParams();
        String url = (String)runningParams.get("url");
        String fileName = (String)runningParams.get("fileName");
        String accNo = bankReceiptRequest.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)bankReceiptRequest.getTransDate());
        logger.info("\u5b81\u6ce2\u94f6\u884c\u673a\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d-{}-{}-\u56de\u5355\u6587\u4ef6\u540d\uff1a{}-\u8bf7\u6c42\u5730\u5740\uff1a{}", new Object[]{accNo, transDateStr, fileName, url});
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return "";
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String rspStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        return BankReceiptResponseEB.success();
    }

    public String recv(InputStream inputStream) {
        Map runningParams = EBContext.getContext().getRunningParams();
        String url = (String)runningParams.get("url");
        String savePath = (String)runningParams.get("savePath");
        String fileName = (String)runningParams.get("fileName");
        try {
            File saveDir;
            byte[] getData = this.readInputStream(inputStream);
            String rspStr = new String(getData);
            if (rspStr.length() < 500) {
                logger.info("\u54cd\u5e94\u62a5\u6587\uff1a\n" + rspStr);
            }
            if (!(saveDir = FileCommonUtils.getFileByPath((String)savePath)).exists()) {
                saveDir.mkdirs();
            }
            File file = FileCommonUtils.getFileByPath((String)(saveDir + File.separator + fileName));
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(getData);
            }
        }
        catch (Exception e) {
            logger.error("\u5b81\u6ce2\u94f6\u884c\u673a\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d-\u56de\u5355\u6587\u4ef6\u540d\uff1a" + fileName + "-\u8bf7\u6c42\u5730\u5740\uff1a" + url + "-\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return "";
    }

    private byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "download";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u4e0b\u8f7d", (String)"DownloadFileImpl_0", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        factory.setHttpHeader("Request Method", "GET");
        factory.setHttpHeader("accept", "*/*");
        factory.setHttpHeader("connection", "Keep-Alive");
        Map runningParams = EBContext.getContext().getRunningParams();
        String url = (String)runningParams.get("url");
        if (!url.contains("HTTPS")) {
            factory.setProtocol("HTTP");
        }
        factory.setIp(url);
    }
}

