/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbcb.dc.services.sign;

import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.nbcb.dc.services.DomHelper;
import kd.ebg.receipt.banks.nbcb.dc.services.receipt.NBCBDcCommConfig;
import kd.ebg.receipt.banks.nbcb.dc.utils.EncodingUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class SignService
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SignService.class);

    public static String sign(Element opReq) throws EBServiceException {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        NBCBDcCommConfig nbcbDcCommConfig = (NBCBDcCommConfig)EBConfigBuilder.getInstance().buildConfig(NBCBDcCommConfig.class, bankLoginId);
        if (!Objects.equals(nbcbDcCommConfig.getIsSig(), "true")) {
            return "null";
        }
        logger.info("---------\u7b7e\u540d\u5f00\u59cb----------");
        SignService signService = new SignService();
        String originData = signService.createSignReqMsg(opReq);
        String sidnedContent = signService.dosign(originData);
        String signedData = signService.getSignedData(sidnedContent);
        logger.info("---------\u7b7e\u540d\u5b8c\u6210----------");
        return signedData;
    }

    private String dosign(String signMsg) throws EBServiceException {
        String sidnedContent = null;
        try {
            logger.info("\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587:\n" + signMsg);
            sidnedContent = this.sendAndRcv4Sign(signMsg);
            logger.info("\u7b7e\u540d\u8fd4\u56de\u62a5\u6587:" + sidnedContent);
            return sidnedContent;
        }
        catch (EBServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            EBServiceException e = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u670d\u52a1\u5668\u7b7e\u540d\u5931\u8d25,\u539f\u56e0:%s", (String)"SignService_5", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), ex.getMessage()), (Throwable)ex);
            logger.error("", (Throwable)e);
            throw e;
        }
    }

    private String createSignReqMsg(Element opReq) throws EBServiceException {
        String originData = DomHelper.element2StringPlain(opReq, "gbk");
        return this.createSignReqMsg(originData);
    }

    private String createSignReqMsg(String originData) throws EBServiceException {
        String requestMsg = "<?xml version=\"1.0\" encoding=\"gbk\" ?>\n<msg>\n<msg_head>\n<msg_type>0</msg_type>\n<msg_id>1005</msg_id>\n<msg_sn>0</msg_sn>\n<version>1</version>\n</msg_head>\n<msg_body>\n<origin_data_len>" + EncodingUtil.encode(originData, "gbk").length + "</origin_data_len>\n<origin_data>" + originData + "</origin_data>\n</msg_body>\n</msg>";
        return requestMsg;
    }

    private String getSignedData(String sidnedContent) throws EBServiceException {
        Element msg;
        Element msgBody;
        String errorNo;
        logger.info("\u51c6\u5907\u89e3\u6790\u8fd4\u56de\u7684\u8282\u70b9<signed_data>\u6570\u636e.");
        if (!sidnedContent.startsWith("<?xml")) {
            String add = "<?xml version=\"1.0\" encoding=\"gb2312\"?><msg>";
            logger.info("\u8fd4\u56de\u6570\u636e\u672a\u5305\u542b<?xml \u5934\u6307\u4ee4,\u94f6\u4f01\u8865\u5145\u6570\u636e:" + add);
            sidnedContent = add + sidnedContent;
        }
        if (null != (errorNo = DomHelper.getChildText(msgBody = DomHelper.getChildElementNotNull(msg = JDomUtils.string2Root((String)sidnedContent, (String)"gb2312"), "msg_body"), "error_no"))) {
            EBServiceException ex = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25, \u7b7e\u540d\u8fd4\u56de\u9519\u8bef\u53f7<error_no>:%s", (String)"SignService_6", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), errorNo));
            logger.error("", (Throwable)ex);
            throw ex;
        }
        String signedData = DomHelper.getChildTextNotNull(msgBody, "signed_data");
        if (signedData != null) {
            return signedData;
        }
        EBServiceException e = EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25,\u8fd4\u56de\u6570\u636e\u4e2d\u8282\u70b9<signed_data>\u4e0d\u5b58\u5728", (String)"SignService_2", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]));
        logger.error("", (Throwable)e);
        throw e;
    }

    private String sendAndRcv4Sign(String signMsg) throws EBServiceException {
        try {
            new BankReceiptRequest();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(signMsg).build();
            SignService signService = new SignService();
            EBContext.getContext().setCharsetName("gbk");
            BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)signService.doBiz((BankRequest)bankReceiptRequest);
            EBContext.getContext().setCharsetName(RequestContextUtils.getBankParameterValue((String)"charset"));
            return (String)receiptResponseEB.getData();
        }
        catch (Exception e) {
            EBServiceException ex = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38,\u539f\u56e0:%s, \u8bf7\u68c0\u67e5\u3002", (String)"SignService_7", (String)"ebg-receipt-banks-nbcb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            logger.info("", (Object)ex);
            throw ex;
        }
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        return bankReceiptRequest.getRequestStr();
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        return BankReceiptResponseEB.success((Object)s);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String port = RequestContextUtils.getBankParameterValue((String)"signPort");
        String protocol = RequestContextUtils.getBankParameterValue((String)"signProtocol");
        factory.setPort(port);
        factory.setProtocol(protocol);
    }
}

