/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gsb.dc.service.api;

import com.google.common.collect.Lists;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gsb.dc.utils.Packer;
import kd.ebg.receipt.banks.gsb.dc.utils.Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfoList = new ArrayList(8);
        this.setCurrentPage("1");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse bizRsp = this.doBiz(request);
            detailInfoList.addAll(bizRsp.getDetails());
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "B2EActTrsQry");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        Element root = Packer.buildHead("B2EActTrsQry", null);
        Element map = JDomUtils.getChildElement((Element)root, (String)"Body").getChild("List").getChild("Map");
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)map, (String)"Currency", (String)bankDetailRequest.getAcnt().getCurrency());
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String s) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        this.setLastPage(true);
        BankAcnt acnt = request.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankResponse = Parser.parser(root);
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element body = root.getChild("Body");
            Element list = body.getChild("List");
            List records = list.getChildren("Map");
            for (int i = 0; i < records.size(); ++i) {
                Element record = (Element)records.get(i);
                if (!acnt.getAccNo().equals(record.getChildTextTrim("AcNo"))) continue;
                if (!"000000".equals(record.getChildTextTrim("ReturnCode"))) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s", (String)"DetailImpl_0", (String)"ebg-receipt-banks-gsb-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
                }
                this.parserDetail(detailList, record, acnt, request);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s", (String)"DetailImpl_0", (String)"ebg-receipt-banks-gsb-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        return new EBBankDetailResponse(detailList);
    }

    public void parserDetail(List<DetailInfo> detailList, Element record, BankAcnt acnt, BankDetailRequest request) {
        Element list = record.getChild("List");
        List maps = list.getChildren("Map");
        String transDate = request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            DetailInfo detail = new DetailInfo();
            String trsJnlNo = map.getChildTextTrim("TrsJnlNo");
            detail.setUniqueSeq(trsJnlNo);
            detail.setReceiptNo(String.join((CharSequence)"_", Lists.newArrayList((Object[])new String[]{acnt.getAccNo(), transDate, trsJnlNo})) + ".pdf");
            detailList.add(detail);
        }
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-receipt-banks-gsb-dc", (Object[])new Object[0]);
    }
}

