/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.dc.service.receipt;

import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cmb.dc.service.CMBDCCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        ChannelSftp sftp = null;
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = request.getBankLoginId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileLink(), downloadListDetail);
        }
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String matchString = accNo + "_" + date;
        CMBDCCommConfig config = (CMBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CMBDCCommConfig.class, bankLoginId);
        BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        String sftp_path = ftpProperties.getFtpPath();
        String string = sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
        if (Objects.equals(config.getCmb_receipt_format(), "pdf")) {
            String dataStr = transDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            matchString = accNo + "_" + dataStr;
        }
        List<Object> fileList = new ArrayList(16);
        try {
            if (ftpProperties.getReceiptAchieveWay().equals("sftp") && SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
            }
            if (ftpProperties.getReceiptAchieveWay().equals("sftp")) {
                Vector ls = SFTPUtils.getInstance().listFiles(sftp_path, sftp);
                for (Object e : ls) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)e;
                    if (file.getAttrs().isDir() || !file.getFilename().startsWith(matchString)) continue;
                    fileList.add(file.getFilename());
                }
            } else if (ftpProperties.getReceiptAchieveWay().equals("bank_login")) {
                fileList = this.getFileByName(matchString, accNo, transDate);
            }
            logger.info("\u627e\u5230\u6587\u4ef6\u5217\u8868\uff1a" + fileList);
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage());
                String msg = String.format(ResManager.loadKDString((String)"\u626b\u63cf\u76ee\u5f55\u4e0b\u6587\u4ef6\u51fa\u9519\uff1a%s", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[0]), e.getMessage());
                throw new ReceiptException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        SFTPUtils.getInstance().close(sftp);
        if (fileList.size() > 0) {
            for (String string2 : fileList) {
                String newFileName;
                if (existMap.containsKey(string2)) continue;
                String[] temp = string2.split("_");
                if (temp.length == 4) {
                    date = temp[1].split("-")[0];
                    newFileName = temp[0] + "_" + date + "_" + temp[2] + "_" + temp[3];
                } else {
                    newFileName = string2;
                }
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileName(newFileName);
                detail.setFileLink(string2);
                result.add(detail);
            }
        }
        boolean isLastFile = false;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            BankReceiptDownloadImpl bankReceiptDownloadImpl = this;
            synchronized (bankReceiptDownloadImpl) {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
                }
            }
        }
        ArrayList<DownloadListDetail> arrayList = new ArrayList<DownloadListDetail>(1);
        for (int i = 0; i < result.size(); ++i) {
            if (i == result.size() - 1) {
                isLastFile = true;
            }
            DownloadListDetail downloadListDetail = (DownloadListDetail)result.get(i);
            List<DownloadListDetail> details = this.download(downloadListDetail, isLastFile, bankLoginId, bakFilePath, sftp, accNo, transDate);
            arrayList.addAll(details);
        }
        return BankReceiptHandleResponseEB.success(arrayList);
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, boolean isLastFile, String bankLoginId, String bakFilePath, ChannelSftp sftp, String accNo, LocalDate transDate) {
        boolean download;
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        if (fileName != null && fileName.length() > 0 && (download = this.ftpDownload(fileName, newFileName, bankLoginId, isLastFile, bakFilePath, sftp, accNo, transDate))) {
            result.add(detail);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ftpDownload(String fileName, String newFileName, String bankLogin, boolean isLastFile, String bakFilePath, ChannelSftp sftp, String accNo, LocalDate transDate) {
        boolean result;
        block17: {
            result = false;
            BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
            String sftp_path = bankFtpProperties.getFtpPath();
            try {
                BankReceiptApiUtil bankReceiptApiUtil;
                File isExistOldFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + newFileName));
                if (isExistOldFile.exists()) {
                    boolean bl = true;
                    return bl;
                }
                if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                    BankReceiptDownloadImpl bankReceiptDownloadImpl = this;
                    synchronized (bankReceiptDownloadImpl) {
                        if (SFTPUtils.getInstance().isAbort(sftp)) {
                            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                        }
                    }
                    sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
                    File saveFile = FileCommonUtils.getFileByPath((String)bakFilePath);
                    if (!saveFile.exists()) {
                        saveFile.mkdirs();
                    }
                    result = SFTPUtils.getInstance().downloadSingleFile(sftp_path, fileName, bakFilePath, sftp);
                    File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                    if (file.exists()) {
                        boolean bl = result = FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)newFileName);
                        return bl;
                    }
                    break block17;
                }
                if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login") && (result = (bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate)).downloadReceiptFile(fileName))) {
                    File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                    result = file.exists() ? FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)newFileName) : false;
                }
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u540d\uff1a" + fileName, new Object[]{e.getMessage()});
                throw new ReceiptException((Throwable)e);
            }
            finally {
                if (isLastFile) {
                    SFTPUtils.getInstance().close(sftp);
                }
            }
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMB_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u62db\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[0]);
    }
}

