/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptImpl.class);
    private int sendRequestTime = 5000;
    private final String SUCCESS = "0";
    private final String NOTSEND = "-1";
    private final String TIMEOUT = "-5";
    private int retryCount = 0;

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        String transDate = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        Map paramMap = request.getParamsMap();
        String code = (String)paramMap.get("code");
        String rrcflg = (String)paramMap.get("rrcflg");
        String clientId = (String)paramMap.get("clientId");
        String requestStr = this.getDownLoadRequest(accNo, transDate, code, rrcflg, clientId);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        Map paramMap = request.getParamsMap();
        String code = (String)paramMap.get("code");
        this.parseResponse(responseStr, code);
        return BankReceiptResponseEB.success();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMD_DC_FRONT_PROXY_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u62db\u884c\u524d\u7f6e\u673a\u8bf7\u6c42\u3002", (String)"BankReceiptImpl_0", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml");
    }

    private String getDownLoadRequest(String accNo, String transDate, String code, String rrcflg, String clientId) {
        String FUNNAM = "SDKCSFDFBRTIMG";
        String DATTYP = "2";
        String LGNNAM = clientId;
        String EACNBR = accNo;
        String BEGDAT = transDate;
        String ENDDAT = transDate;
        String RRCCOD = code;
        Element root = JDomExtUtils.createRoot((String)"CMBSDKPGK");
        Element head = JDomUtils.addChild((Element)root, (String)"INFO");
        JDomUtils.addChild((Element)head, (String)"FUNNAM", (String)FUNNAM);
        JDomUtils.addChild((Element)head, (String)"DATTYP", (String)DATTYP);
        JDomUtils.addChild((Element)head, (String)"LGNNAM", (String)LGNNAM);
        Element body = JDomUtils.addChild((Element)root, (String)"CSRRCFDFY0");
        JDomUtils.addChild((Element)body, (String)"EACNBR", (String)EACNBR);
        JDomUtils.addChild((Element)body, (String)"BEGDAT", (String)BEGDAT);
        JDomUtils.addChild((Element)body, (String)"ENDDAT", (String)ENDDAT);
        JDomUtils.addChild((Element)body, (String)"RRCFLG", (String)rrcflg);
        JDomUtils.addChild((Element)body, (String)"RRCCOD", (String)RRCCOD);
        return JDomExtUtils.doc2StrGBK((Document)new Document(root));
    }

    private void parseResponse(String response, String code) {
        switch (this.parseRes(response)) {
            case "0": {
                this.retryCount = 0;
                break;
            }
            case "-5": {
                if (this.retryCount > 3) {
                    this.sendRequestTime = 10000;
                    this.retryCount = 0;
                } else {
                    ++this.retryCount;
                }
                this.wait(this.sendRequestTime);
                break;
            }
            case "-1": {
                logger.error("\u63d0\u4ea4\u4e3b\u673a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u4eba\u5458\uff0c\u786e\u8ba4\u5f53\u524d\u8d26\u53f7\u662f\u5426\u5df2\u5f00\u901a\u7535\u5b50\u56de\u5355\u4e1a\u52a1(\u56de\u5355\u7c7b\u578b\uff1a" + code + ")\u3002");
                this.retryCount = 0;
                break;
            }
            default: {
                this.retryCount = 0;
            }
        }
    }

    private String parseRes(String response) {
        String result;
        String errorMsg;
        block11: {
            errorMsg = "";
            result = "";
            try {
                Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
                Element status = root.getChild("INFO");
                String FUNNAM = JDomUtils.getUnNullChildElement((Element)status, (String)"FUNNAM").getTextTrim();
                String DATTYP = JDomUtils.getUnNullChildElement((Element)status, (String)"DATTYP").getTextTrim();
                String RETCOD = JDomUtils.getUnNullChildElement((Element)status, (String)"RETCOD").getTextTrim();
                String ERRMSG = JDomUtils.getUnNullChildElement((Element)status, (String)"ERRMSG").getTextTrim();
                result = RETCOD;
                if ("0".equalsIgnoreCase(RETCOD) && "2".equalsIgnoreCase(DATTYP) && "SDKCSFDFBRTIMG".equalsIgnoreCase(FUNNAM)) {
                    this.sendRequestTime = 10000;
                } else if ("-5".equalsIgnoreCase(RETCOD)) {
                    logger.info("\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u8bf7\u6c42\u53d1\u9001\u8fc7\u4e8e\u9891\u7e41\uff0c\u5c06\u964d\u4f4e\u8bf7\u6c42\u7684\u53d1\u9001\u9891\u7387\u3002");
                    this.sendRequestTime *= 2;
                } else {
                    logger.info("\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u5931\u8d25\uff0c\u8fd4\u56de\u7801 = " + RETCOD);
                    if (EBGStringUtils.isEmpty((String)errorMsg)) {
                        errorMsg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u56de\u5355\u67e5\u8be2\u63a5\u53e3\u63a5\u6536\u5230\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]:%2$s\u3002", (String)"BankReceiptImpl_5", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[]{RETCOD, ERRMSG}), new Object[0]);
                    } else if (!errorMsg.contains("&")) {
                        errorMsg = errorMsg + String.format(ResManager.loadKDString((String)"& \u8c03\u7528\u56de\u5355\u67e5\u8be2\u63a5\u53e3\u63a5\u6536\u5230\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]:%2$s\u3002", (String)"BankReceiptImpl_6", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[0]), RETCOD, ERRMSG);
                    }
                }
            }
            catch (Exception e) {
                result = "-3";
                logger.error("\u6570\u636e\u62a5\u6587\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
                if (EBGStringUtils.isEmpty((String)errorMsg)) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u62a5\u6587\u89e3\u6790\u5931\u8d25\uff1a%s\u3002", (String)"BankReceiptImpl_7", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[0]), e.getMessage());
                }
                if (errorMsg.contains("&")) break block11;
                errorMsg = errorMsg + String.format(ResManager.loadKDString((String)"& \u6570\u636e\u62a5\u6587\u89e3\u6790\u5931\u8d25\uff1a%s\u3002", (String)"BankReceiptImpl_8", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[0]), e.getMessage());
            }
        }
        if (errorMsg.contains("&")) {
            throw new ReceiptException(errorMsg);
        }
        return result;
    }

    private void wait(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
    }
}

