/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.adbc.dc.service.detail;

import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.adbc.dc.service.Packer;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class DetailPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailPacker.class);

    public String packDetail(BankDetailRequest rqst, String pageTag) {
        logger.info("\u5386\u53f2\u8d26\u6237\u6c47\u5212\u4ea4\u6613\u8bf7\u6c42\u65f6\u95f4-----\u5f00\u59cb---packHisDetail");
        BankAcnt backAcnt = rqst.getAcnt();
        String body = this.createBody(rqst, backAcnt.getAccNo(), pageTag);
        String bodyLen = Packer.getLength(body);
        String header = Packer.createHeadMessage("eb.qry.023.1", bodyLen);
        String reqMsg = header + body;
        return reqMsg;
    }

    private String createBody(BankDetailRequest rqst, String accountNo, String pageTag) {
        StringBuilder sbBody = new StringBuilder();
        String requestTime = LocalDateUtil.formatDate((LocalDate)rqst.getStartDate(), (String)"yyyy-MM-dd");
        logger.info("\u8d26\u6237\u6c47\u5212\u4ea4\u6613\u660e\u7ec6\u8bf7\u6c42\u65f6\u95f4-----\u5f00\u59cb---{}", (Object)requestTime);
        try {
            String encoding = "UTF-8";
            sbBody.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\"?>\r\n");
            sbBody.append("<Document xmlns=\"").append("eb.qry.023.1").append("\">\r\n");
            sbBody.append("<InqAccount>");
            sbBody.append("<Account>").append(accountNo).append("</Account>");
            sbBody.append("<Date>").append(requestTime).append("</Date>");
            sbBody.append("</InqAccount>");
            sbBody.append("</Document>");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6784\u9020\u5b57\u8282\u6d41\u5931\u8d25\uff0c\u5c01\u88c5\u8d26\u6237\u6c47\u5212\u660e\u7ec6\u62a5\u6587\u5931\u8d25%1$s==%2$s:", (String)"DetailPacker_1", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]), rqst.getPageNum(), pageTag), (Throwable)e);
        }
        return sbBody.toString();
    }
}

