/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.adbc.dc.service.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.adbc.dc.service.Parser;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParser.class);
    private static int pageSize = 50;

    public List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) {
        ArrayList<DetailInfo> detailInfoList = new ArrayList();
        BankResponse rsp = Parser.parseResponse(rspStr);
        if (!"S0000".equals(rsp.getResponseCode())) {
            RequestContextUtils.setRunningParam((String)"lastPageKey", (String)"true");
            throw new ReceiptException(rsp.getResponseMessage());
        }
        detailInfoList = this.getDetail(rspStr, rqst.getAcnt());
        logger.info("\u67e5\u8be2\u5386\u53f2\u8d26\u6237\u6c47\u5212\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u54cd\u5e94\u7801S0000, \u67e5\u8be2\u6210\u529f\u3002");
        return detailInfoList;
    }

    public List<DetailInfo> getDetail(String rspStr, BankAcnt reqAcnt) {
        String context = Parser.getRespContext(rspStr);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        try {
            Element bankDate = JDomUtils.string2Root((String)context, (String)"UTF-8");
            Element accounts = bankDate.getChild("GiroInfo");
            String account = accounts.getChildTextTrim("Account");
            if (!reqAcnt.getAccNo().equals(account)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u8d26\u53f7\u4e0e\u8bf7\u6c42\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6c42\u8d26\u53f7\u4e3a\uff1a%s\u3002", (String)"DetailParser_2", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]), reqAcnt.getAccNo()));
            }
            List accountDetailsList = accounts.getChildren("GiroDetails");
            logger.info("accountDetailsList-----{}", (Object)accountDetailsList.size());
            DetailInfo detailInfo = null;
            for (Element accountDetails : accountDetailsList) {
                detailInfo = new DetailInfo();
                String transferSum = accountDetails.getChildText("Amount");
                String flag = accountDetails.getChildText("Flag");
                String offerSetAccount = accountDetails.getChildText("OfferSetAccount");
                String offerSetName = accountDetails.getChildText("OfferSetName");
                String offerSetBankName = accountDetails.getChildText("OfferSetBankName");
                String transferFlowNo = accountDetails.getChildText("BankSerial");
                logger.info("\u94f6\u884c\u6d41\u6c34\u53f7-----{}", (Object)transferFlowNo);
                String transferDate = accountDetails.getChildText("TransDate");
                String balance = accountDetails.getChildText("Balance");
                if ("0".equals(flag)) {
                    detailInfo.setDebitAmount(new BigDecimal(transferSum));
                    detailInfo.setCreditAmount(BigDecimal.valueOf(0.0));
                } else {
                    detailInfo.setDebitAmount(BigDecimal.valueOf(0.0));
                    detailInfo.setCreditAmount(new BigDecimal(transferSum));
                }
                detailInfo.setAccNo(reqAcnt.getAccNo());
                detailInfo.setCurrency("CNY");
                detailInfo.setOppAccNo(offerSetAccount);
                detailInfo.setOppAccName(offerSetName);
                detailInfo.setOppBankName(offerSetBankName);
                detailInfo.setReversed1(flag);
                detailInfo.setReversed2(transferSum);
                detailInfo.setPayBankDetailSeqID(transferFlowNo);
                detailInfo.setTransDate(LocalDateUtil.date2LocalDate((Date)DateUtil.string2Date((String)transferDate, (String)"yyyy-MM-dd")));
                detailInfo.setBalance(StringUtils.isEmpty((String)balance) ? null : new BigDecimal(balance));
                detailInfos.add(detailInfo);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8d26\u6237\u6c47\u5212\u4ea4\u6613\u660e\u7ec6\u62a5\u6587\u5931\u8d25--%s\u3002", (String)"DetailParser_3", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]), rspStr), (Throwable)e);
        }
        return detailInfos;
    }
}

