/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.adbc.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.adbc.dc.service.receipt.api.ReceiptPacker;
import kd.ebg.receipt.banks.adbc.dc.service.receipt.api.ReceiptParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class DownloadReceiptFileImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadReceiptFileImpl.class);

    public String pack(BankReceiptRequest request) {
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate(), (String)"yyyy-MM-dd");
        String accNo = request.getAccNo();
        Map paramMap = request.getParamsMap();
        String bankSerial = (String)paramMap.get("bankSerial");
        String flag = (String)paramMap.get("flag");
        ReceiptPacker receiptPacker = new ReceiptPacker();
        String requestStr = receiptPacker.packReceiptRequest(bankSerial, accNo, transDateStr, flag);
        logger.info("\u4e2d\u56fd\u519c\u4e1a\u53d1\u5c55\u94f6\u884c\u76f4\u8054\u7248-\u53d1\u8d77\u7535\u5b50\u56de\u5355\u4e0b\u8f7d-\u8bf7\u6c42\u62a5\u6587\uff1a\n" + requestStr);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        logger.info("\u4e2d\u56fd\u519c\u4e1a\u53d1\u5c55\u94f6\u884c\u76f4\u8054\u7248-\u7535\u5b50\u56de\u5355\u4e0b\u8f7d-\u54cd\u5e94\u62a5\u6587\uff1a\n" + responseStr);
        ReceiptParser receiptParser = new ReceiptParser();
        String fileName = ReceiptParser.getFileName(responseStr);
        return BankReceiptResponseEB.success((Object)fileName);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "eb.qry.035.1";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u519c\u4e1a\u53d1\u5c55\u94f6\u884c\u76f4\u8054\u7248-\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u8bf7\u6c42", (String)"DownloadReceiptFileImpl_0", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }
}

