/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cqb.dc.receipt.fetch;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.cqb.dc.receipt.api.DetailImpl;
import kd.ebg.receipt.banks.cqb.dc.receipt.api.GetBankReceiptFileImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        String accNo = task.getAccNo();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate transDate = task.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        DetailImpl bankReceiptQuery = new DetailImpl();
        List detailInfoList = bankReceiptQuery.queryTransDetail(accNo, transDate, transDate);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        GetBankReceiptFileImpl getBankReceiptFile = new GetBankReceiptFileImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        for (DetailInfo detail : detailInfoList) {
            String fileName = BankReceiptFetchListImpl.packFileName(accNo, transDateStr, detail, countMap);
            if (existMap.containsKey(fileName)) {
                DownloadListDetail downloadListDetail = (DownloadListDetail)existMap.get(fileName);
                downloadListDetail.setReceiptJson(detail.getJson());
                result.add(downloadListDetail);
                continue;
            }
            try {
                bankReceiptRequest.setRequestStr(detail.getBizRefNo());
                BankReceiptResponseEB receiptResponseEB = getBankReceiptFile.doBiz(bankReceiptRequest);
                String responseStr = (String)receiptResponseEB.getData();
                if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode() && FileCommonUtils.base64ToFile((String)responseStr, (String)(bakFilePath + File.separator + fileName))) {
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    downloadListDetail.setFileName(fileName);
                    downloadListDetail.setFileLink(fileName);
                    downloadListDetail.setReceiptJson(detail.getJson());
                    result.add(downloadListDetail);
                    continue;
                }
                logger.error("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u9519\u8bef\u6570\u636e\uff0c\u54cd\u5e94\u62a5\u6587\u4e3a:" + responseStr);
            }
            catch (Throwable e) {
                logger.error("\u8c03\u7528\u56de\u5355\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage(), e);
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-cqb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public static String packFileName(String accNo, String transDateStr, DetailInfo detail, Map<String, Integer> countMap) {
        String transNo = detail.getBizRefNo();
        String amount = detail.getReversed1();
        String acctAmt = detail.getReversed2();
        String oppAccNo = detail.getOppAccNo();
        StringBuilder sb = new StringBuilder();
        sb.append(accNo).append("_");
        sb.append(transDateStr).append("_");
        sb.append(oppAccNo).append("_");
        sb.append(amount).append("_");
        sb.append(acctAmt).append("_");
        sb.append(transNo);
        String orderNo = sb.toString();
        if (countMap.containsKey(orderNo)) {
            int serial = countMap.get(orderNo) + 1;
            countMap.put(orderNo, serial);
            sb.append("_").append(String.format("%04d", serial));
        } else {
            countMap.put(orderNo, 0);
        }
        sb.append(".pdf");
        return sb.toString();
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

