/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.abc.dc;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.receipt.common.framework.properties.BankPropertyConfig;
import kd.ebg.receipt.common.framework.properties.PropertyConfigItem;

public class BankBusinessConfig
extends BankPropertyConfig {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BankBusinessConfig.class);
    public static final String ABC_EB_FRONT = "front_abc_eb";
    public static final String ABC_DC_FRONT = "front_abc_dc";
    public static final String SHANGHAISALARY = "shanghaisalary";
    public static final String BATHSALARY = "bathsalary";
    public static final String NORMALPAY = "normalpay";
    public static final String IS_PUSHED_FROM_MASTER = "isPushedFromMaster";
    private static final PropertyConfigItem ABC_DC_GroupAcntPool = PropertyConfigItem.builder().key("ABC_DC_GroupAcntPool").name(ResManager.loadKDString((String)"\u96c6\u56e2\u8d26\u6237\u6c60", (String)"BankBusinessConfig_0", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u96c6\u56e2\u8d26\u6237\u4ed8\u6b3e\u65f6\uff0c\u9700\u5339\u914d\u96c6\u56e2\u8d26\u6237\u6c60\u8d26\u53f7\uff0c\u4ee5\u786e\u5b9a\u4f7f\u7528\u54ea\u4e2a\u63a5\u53e3\u3002", (String)"BankBusinessConfig_1", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).minValueNum(0).maxValueNum(200).build();
    private static final PropertyConfigItem ABC_DC_InnerAcntPool = PropertyConfigItem.builder().key("ABC_DC_InnerAcntPool").name(ResManager.loadKDString((String)"\u519c\u884c\u5185\u90e8\u7ed3\u7b97\u8d26\u53f7\u6c60", (String)"BankBusinessConfig_2", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u519c\u884c\u5185\u90e8\u7ed3\u7b97\u8d26\u53f7\u6c60\uff1a\u5f53\u7ed3\u7b97\u8d26\u53f7\u4e3a\u6b64\u7c7b\u8d26\u53f7\u65f6\uff0c\u5373\u4f7f\u540c\u4e3a\u519c\u884c\uff0c\u4e5f\u9700\u8bbe\u7f6e\u8de8\u884c\u6807\u8bc6\u3002\u591a\u4e2a\u8d26\u53f7\u914d\u7f6e\u65f6\uff0c\u8bf7\u4ee5\u5206\u53f7\u5206\u9694\u3002", (String)"BankBusinessConfig_3", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).minValueNum(0).maxValueNum(200).build();
    private static final PropertyConfigItem ABC_DC_NotePoolInfo = PropertyConfigItem.builder().key("ABC_DC_NotePoolInfo").name(ResManager.loadKDString((String)"\u519c\u884c\u7535\u7968\u96c6\u56e2\u6210\u5458\u4fe1\u606f\u6c60", (String)"BankBusinessConfig_4", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u914d\u7f6e\u519c\u884c\u6301\u7968\u6210\u5458\u540d\u79f0\u4e0eid\uff0c\u5728\u505a\u7968\u636e\u6c60\u4ea4\u6613\u65f6\u9700\u8981\u3002\u4e0e\u519c\u884c\u7b7e\u7ea6\u7968\u636e\u6c60\u4e1a\u52a1\u519c\u884c\u63d0\u4f9bid", (String)"BankBusinessConfig_5", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).minValueNum(0).maxValueNum(200).build();
    private static final PropertyConfigItem ABC_DC_FRONTSWITCH = PropertyConfigItem.builder().key("ABC_DC_FRONTSWITCH").name(ResManager.loadKDString((String)"\u519c\u884c\u524d\u7f6e\u673a\u914d\u7f6e", (String)"BankBusinessConfig_6", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u5f53\u94f6\u884c\u524d\u7f6e\u673a\u5207\u6362\u65f6\u9700\u8981,\u5c06\u6b64\u914d\u7f6e\u6210\u76f8\u5e94\u7684\u524d\u7f6e\u673a\u3002", (String)"BankBusinessConfig_7", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u519c\u884c\u516c\u7f51\u7248\u524d\u7f6e\u673a\uff08ABC_DC\uff09", (String)"BankBusinessConfig_8", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u519c\u884c\u76f4\u8fde\u7248\u524d\u7f6e\u673a\uff08ABC_EB\uff09", (String)"BankBusinessConfig_9", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"front_abc_dc", "front_abc_eb"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"front_abc_dc"})).build();
    private static final PropertyConfigItem abc_dc_payStateTrans = PropertyConfigItem.builder().key("abc_dc_payStateTrans").name(ResManager.loadKDString((String)"\u540c\u6b65\u63a5\u53e3\u9009\u62e9", (String)"BankBusinessConfig_10", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u4e0d\u4fee\u6539", (String)"BankBusinessConfig_58", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames((List)Lists.newArrayList((Object[])new String[]{"CQRT04", "CQRT71"})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"CQRT04", "CQRT71"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"CQRT04"})).build();
    private static final PropertyConfigItem abc_dc_isAddKDFlagToPay = PropertyConfigItem.builder().key("abc_dc_isAddKDFlagToPay").name(ResManager.loadKDString((String)"\u652f\u4ed8\u662f\u5426\u9700\u8981\u8fdb\u884cKD\u6807\u8bb0(\u5f71\u54cd:\u7535\u5b50\u56de\u5355\u6458\u8981\u4f1a\u9644\u5e26KD\u6807\u8bb0\uff0c\u4ed8\u6b3e\u6458\u8981\u957f\u5ea6\u589e\u52a0)", (String)"BankBusinessConfig_12", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u652f\u4ed8\u662f\u5426\u9700\u8981\u8fdb\u884cKD\u6807\u8bb0(\u7528\u4e8e\u667a\u80fd\u5bf9\u8d26\u548c\u8bc6\u522b\u91d1\u8776\u7684\u4ed8\u6b3e):1)\u5426 \uff1a\u6458\u8981\u4e0d\u52a0\u5165KD\u6807\u8bb0\uff0c\u9ed8\u8ba4\u65b9\u5f0f;2)\u662f \uff1a\u6458\u8981\u52a0\u5165KD\u6807\u8bb0.", (String)"BankBusinessConfig_80", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames(falseTrueCN).sourceValues(falseTrueEN).defaultValues(defaultFalse).build();
    private static final PropertyConfigItem ABC_DC_BankChargeConfig = PropertyConfigItem.builder().key("ABC_DC_BankChargeConfig").name(ResManager.loadKDString((String)"\u519c\u884c\u4e3b\u52a8\u6263\u6b3e\u7684\u6807\u8bc6", (String)"BankBusinessConfig_16", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u519c\u884c\u4e3b\u52a8\u6263\u6b3e\u7684\u6807\u8bc6", (String)"BankBusinessConfig_16", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).minValueNum(0).maxValueNum(200).sourceNames((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u6765\u6e90\u7f16\u53f7", (String)"BankBusinessConfig_17", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6765\u6e90\u540d\u79f0", (String)"BankBusinessConfig_18", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u6807\u793a", (String)"BankBusinessConfig_19", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f\u5426\u751f\u6210\u4ed8\u6b3e\u5355", (String)"BankBusinessConfig_20", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"text", "text", "text", "checkbox"})).build();
    private static final PropertyConfigItem ABC_DC_ISALLOCATIONTOCOMPANY = PropertyConfigItem.builder().key("abc_dc_isAllocationToCompany").name(ResManager.loadKDString((String)"\u5212\u62e8\u662f\u5426\u9700\u8981\u8d70\u666e\u901a\u652f\u4ed8", (String)"BankBusinessConfig_21", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u5212\u62e8(\u81ea\u4e3b\u5f52\u96c6 (CFRT00\u4ea4\u6613))\u662f\u5426\u9700\u8981\u8d70\u666e\u901a\u652f\u4ed8(\u6c47\u5151-\u5355\u7b14\u5bf9\u516c (CFRT02\u4ea4\u6613)\uff0c\u6c47\u5151-\u5355\u7b14\u5bf9\u79c1 (CFRT21\u4ea4\u6613)):", (String)"BankBusinessConfig_62", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames(trueFalseCN).sourceValues((List)Lists.newArrayList((Object[])new String[]{"AllocationToCompany", "Allocation"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"Allocation"})).build();
    private static final PropertyConfigItem ABC_DC_ISLINKPAYTOCOMPANY = PropertyConfigItem.builder().key("abc_dc_isLinkpayToCompany").name(ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u662f\u5426\u9700\u8981\u8d70\u666e\u901a\u652f\u4ed8", (String)"BankBusinessConfig_25", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u662f\u5426\u9700\u8981\u8d70\u666e\u901a\u652f\u4ed8:", (String)"BankBusinessConfig_65", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames(trueFalseCN).sourceValues((List)Lists.newArrayList((Object[])new String[]{"linkpayToCompany", "linkpay"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"linkpay"})).build();
    private static final PropertyConfigItem ABC_DC_ISSHANGHAIPAYBATCH = PropertyConfigItem.builder().key("abc_dc_isShangHaiPaybatch").name(ResManager.loadKDString((String)"\u662f\u5426\u9700\u8981\u8d70\u4e0a\u6d77\u519c\u884c\u6279\u91cf\u4ee3\u53d1\u63a5\u53e3", (String)"BankBusinessConfig_29", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u662f\u5426\u9700\u8981\u8d70\u4e0a\u6d77\u519c\u884c\u6279\u91cf\u4ee3\u53d1\u63a5\u53e3:", (String)"BankBusinessConfig_67", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames(trueFalseCN).sourceValues((List)Lists.newArrayList((Object[])new String[]{"shanghaiPayBatch", "normalpay"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"normalpay"})).build();
    private static final PropertyConfigItem ABC_DC_ISTRANS2BATCHPAY = PropertyConfigItem.builder().key("abc_dc_istrans2batchpay").name(ResManager.loadKDString((String)"\u666e\u901a\u652f\u4ed8\u662f\u5426\u9700\u8981\u8d70\u6279\u91cf\u63a5\u53e3", (String)"BankBusinessConfig_33", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u666e\u901a\u652f\u4ed8\u662f\u5426\u9700\u8981\u8d70\u6279\u91cf\u63a5\u53e3(IBBF02\u3001IBBF01)\uff0c\u6279\u91cf\u63a5\u53e3\u9700\u8981\u4e0e\u94f6\u884c\u5f00\u901a:", (String)"BankBusinessConfig_69", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames(trueFalseCN).sourceValues((List)Lists.newArrayList((Object[])new String[]{"batch", "single"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"single"})).build();
    private static final PropertyConfigItem ABC_DC_INCOMEINTERFACE = PropertyConfigItem.builder().key("ABC_DC_INCOMEINTERFACE").name(ResManager.loadKDString((String)"\u4ee3\u6263\u63a5\u53e3\u9009\u62e9", (String)"BankBusinessConfig_37", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u4ee3\u6263\u63a5\u53e3\u9009\u62e9:", (String)"BankBusinessConfig_71", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames((List)Lists.newArrayList((Object[])new String[]{"CFRT73", "CFRB18"})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"CFRT73", "CFRB18"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"CFRT73"})).build();
    private static final PropertyConfigItem ABC_DC_INCOMERECINDWAY = PropertyConfigItem.builder().key("ABC_DC_INCOMERECINDWAY").name(ResManager.loadKDString((String)"\u4ee3\u6263\u63a5\u53e3\u662f\u5426\u9700\u8981\u6821\u9a8c\u624b\u673a\u53f7", (String)"BankBusinessConfig_41", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"CFRB18\u4ee3\u6263\u63a5\u53e3\u4ed8\u6b3e\u662f\u5426\u9700\u8981\u6821\u9a8c\u624b\u673a\u53f7:", (String)"BankBusinessConfig_73", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames(trueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultTrue).build();
    private static final PropertyConfigItem ABC_DC_SALARYBATCHSIZE = PropertyConfigItem.builder().key("ABC_DC_SALARYBATCHSIZE").name(ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u5355\u7b14\u4ed8\u6b3e\u7b14\u6570\u4e0a\u9650", (String)"BankBusinessConfig_45", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u5355\u7b14\u4ed8\u6b3e\u7b14\u6570\u4e0a\u9650\uff0c\u9ed8\u8ba4500:", (String)"BankBusinessConfig_75", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames((List)Lists.newArrayList((Object[])new String[]{"500", "1000", "2000"})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"500", "1000", "2000"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"500"})).build();
    private static final PropertyConfigItem ABC_DC_INCOME_NVOUCHERTYPE = PropertyConfigItem.builder().key("ABC_DC_INCOME_NVOUCHERTYPE").name(ResManager.loadKDString((String)"CFRB18\u4ee3\u6263\u5408\u7ea6\u7c7b\u578b", (String)"BankBusinessConfig_47", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"CFRB18\u4ee3\u6263\u5408\u7ea6\u7c7b\u578b", (String)"BankBusinessConfig_47", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).isAccNo(true).build();
    private static final PropertyConfigItem ABC_DC_INCOME_NFACCNO = PropertyConfigItem.builder().key("ABC_DC_INCOME_NFACCNO").name(ResManager.loadKDString((String)"CFRB18\u5408\u7ea6\u8d26\u53f7", (String)"BankBusinessConfig_48", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"CFRB18\u5408\u7ea6\u8d26\u53f7", (String)"BankBusinessConfig_48", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).isAccNo(true).build();
    private static final PropertyConfigItem ABC_DC_PAYTRANSCODE = PropertyConfigItem.builder().key("abc_dc_payTransCode").name(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u63a5\u53e3\u65b9\u5f0fcode\u9009\u62e9", (String)"BankBusinessConfig_49", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u63a5\u53e3\u65b9\u5f0fcode\u9009\u62e9,\u4e0d\u540c\u7684\u4e1a\u52a1\u8fd4\u56de\u7684code\u5b57\u6bb5\u4e0d\u4e00\u6837:", (String)"BankBusinessConfig_76", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames((List)Lists.newArrayList((Object[])new String[]{"TransCode", "CCTransCode"})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"TransCode", "CCTransCode"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"TransCode"})).build();
    private static final PropertyConfigItem ABC_DC_PUSH_WAY = PropertyConfigItem.builder().key("isPushedFromMaster").name(ResManager.loadKDString((String)"\u56de\u5355\u662f\u5426\u4ece\u603b\u884c\u63a8\u9001", (String)"BankBusinessConfig_52", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u603b\u884c\u63a8\u9001\u548c\u5206\u884c\u63a8\u9001\u6587\u4ef6\u540d\u4e0d\u4e00\u6837:", (String)"BankBusinessConfig_78", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])).sourceNames((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u662f", (String)"BankBusinessConfig_56", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426", (String)"BankBusinessConfig_57", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])})).sourceValues((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u662f", (String)"BankBusinessConfig_56", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426", (String)"BankBusinessConfig_57", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])})).defaultValues((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u662f", (String)"BankBusinessConfig_56", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0])})).build();

    public String getBankVersionID() {
        return "ABC_DC";
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        return Lists.newArrayList((Object[])new PropertyConfigItem[]{ABC_DC_GroupAcntPool, ABC_DC_InnerAcntPool, ABC_DC_NotePoolInfo, ABC_DC_FRONTSWITCH, abc_dc_isAddKDFlagToPay, ABC_DC_BankChargeConfig, abc_dc_payStateTrans, ABC_DC_ISALLOCATIONTOCOMPANY, ABC_DC_ISLINKPAYTOCOMPANY, ABC_DC_ISSHANGHAIPAYBATCH, ABC_DC_ISTRANS2BATCHPAY, ABC_DC_INCOMEINTERFACE, ABC_DC_INCOMERECINDWAY, ABC_DC_SALARYBATCHSIZE, ABC_DC_INCOME_NVOUCHERTYPE, ABC_DC_INCOME_NFACCNO, ABC_DC_PAYTRANSCODE, ABC_DC_PUSH_WAY});
    }

    public static boolean isAddKDFlagToPay() {
        return abc_dc_isAddKDFlagToPay.getCurrentValueAsBoolean();
    }

    public static List<String> getCompanyAccountPool() {
        return ABC_DC_GroupAcntPool.getCurrentValues();
    }

    public static List<String> getInnerAcntPool() {
        return ABC_DC_InnerAcntPool.getCurrentValues();
    }

    public static List<String> getNotePoolMembersInfo() {
        return ABC_DC_NotePoolInfo.getCurrentValues();
    }

    public static void setNotePoolMembersInfo(String[] temp) {
        ABC_DC_NotePoolInfo.setCurrentValues(Arrays.asList(temp));
    }

    public static String getNotePoolInfo(String memberName) {
        String result = "";
        List membersInfos = ABC_DC_NotePoolInfo.getCurrentValues();
        for (String info : membersInfos) {
            if (!info.startsWith(memberName)) continue;
            result = info;
        }
        return result;
    }

    public static String getABC_DC_Front() {
        return ABC_DC_FRONTSWITCH.getCurrentValue();
    }

    public static boolean isUseCQRT71() {
        return "CQRT71".equals(abc_dc_payStateTrans.getCurrentValue());
    }

    public static Map<String, String> getBankChargeConfig() {
        HashMap absMap = Maps.newHashMapWithExpectedSize((int)8);
        List bankChargeFlags = ABC_DC_BankChargeConfig.getCurrentValues();
        for (String bankChargeFlag : bankChargeFlags) {
            String[] configArr;
            for (String config : configArr = bankChargeFlag.split(";")) {
                String[] columns = config.split(",");
                logger.info("\u975e\u94f6\u884c\u4e3b\u52a8\u6263\u5212\u7684\u914d\u7f6e\u9879:" + config);
                if (columns.length != 4) {
                    logger.error("\u519c\u884c\u4ee3\u6263\u914d\u7f6e\u683c\u5f0f\u9519\u8bef");
                    continue;
                }
                if (!"YHKK".equalsIgnoreCase(columns[2]) || !"true".equalsIgnoreCase(columns[3])) continue;
                absMap.put(columns[0], columns[1]);
            }
        }
        return absMap;
    }

    public static boolean isInnerPoolTransfer(String payAccount, String payeeAccount) {
        List<String> innerAcntPool = BankBusinessConfig.getInnerAcntPool();
        if (BankBusinessConfig.matchFromArray(innerAcntPool, payAccount) && BankBusinessConfig.matchFromArray(innerAcntPool, payeeAccount)) {
            return false;
        }
        return BankBusinessConfig.matchFromArray(innerAcntPool, payeeAccount);
    }

    private static boolean matchFromArray(List<String> array, String target) {
        for (String key : array) {
            if (!key.equals(target)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllocationToCompanyPay() {
        return "AllocationToCompany".equalsIgnoreCase(ABC_DC_ISALLOCATIONTOCOMPANY.getCurrentValue());
    }

    public static boolean islinkpayToCompanyPay() {
        return "linkpayToCompany".equalsIgnoreCase(ABC_DC_ISLINKPAYTOCOMPANY.getCurrentValue());
    }

    public static boolean isShangHaiPaybatch() {
        return "shanghaiPayBatch".equalsIgnoreCase(ABC_DC_ISSHANGHAIPAYBATCH.getCurrentValue());
    }

    public static boolean isTrans2Batch() {
        return "batch".equalsIgnoreCase(ABC_DC_ISTRANS2BATCHPAY.getCurrentValue());
    }

    public static boolean isUseCFRB18() {
        return Objects.equal((Object)"CFRB18", (Object)ABC_DC_INCOMEINTERFACE.getCurrentValue());
    }

    public static boolean isCheckThePhoneNumber() {
        return "true".equals(ABC_DC_INCOMERECINDWAY.getCurrentValue());
    }

    public static String getSalaryBatchSize() {
        return ABC_DC_SALARYBATCHSIZE.getCurrentValue();
    }

    public static String getNVoucherType(String accNo) {
        return ABC_DC_INCOME_NVOUCHERTYPE.getCurrentValueWithObjectID(accNo);
    }

    public static String getNFAccNo(String accNo) {
        return ABC_DC_INCOME_NFACCNO.getCurrentValueWithObjectID(accNo);
    }

    public static boolean isTransCode() {
        return "TransCode".equals(ABC_DC_PAYTRANSCODE.getCurrentValue());
    }

    public static boolean isGroupAcntPoolTransfer(String payAccount, String payeeAccount) {
        List<String> companyAccounts = BankBusinessConfig.getCompanyAccountPool();
        return BankBusinessConfig.matchFromArray(companyAccounts, payAccount) && BankBusinessConfig.matchFromArray(companyAccounts, payeeAccount);
    }

    public static boolean isPushedFromMaster() {
        return ResManager.loadKDString((String)"\u662f", (String)"BankBusinessConfig_56", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]).equals(ABC_DC_PUSH_WAY.getCurrentValue());
    }
}

