/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.abc.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.abc.dc.service.receipt.AbcDcCommonConfig;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.PDFFilter;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        boolean isToday = request.getTransDate().equals(LocalDate.now());
        String bankLoginId = request.getBankLoginId();
        AbcDcCommonConfig abcDcCommonConfig = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLoginId);
        boolean isPushed = abcDcCommonConfig.getAbcPushMode().equals("true");
        boolean hisChoose = abcDcCommonConfig.getHistorychoose().equals("CMRA25");
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
            if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId() || downloadListDetail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId()) {
                if (!isToday) continue;
                result.add(downloadListDetail);
                continue;
            }
            if (!isToday && !downloadListDetail.getFileLink().contains(".zip") && !isPushed && hisChoose) continue;
            List<DownloadListDetail> details = this.download(downloadListDetail, abcDcCommonConfig);
            result.addAll(details);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, AbcDcCommonConfig abcDcCommonConfig) {
        String bankLoginId = detail.getBankLoginId();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        boolean isPushed = abcDcCommonConfig.getAbcPushMode().equals("true");
        boolean isOFDReceipt = Objects.equals(abcDcCommonConfig.getReceiptFileType(), "OFD");
        if (!isPushed) {
            logger.info("\u5f00\u59cb\u4e0b\u8f7d\u975e\u4e3b\u52a8\u63a8\u9001\u6a21\u5f0f\u7684\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355-{}-{}", new Object[]{detail.getAccNo(), detail.getTransDate()});
            result.addAll(this.download_proxyMode(detail, bankLoginId, isOFDReceipt));
        } else {
            result.add(detail);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<DownloadListDetail> download_proxyMode(DownloadListDetail detail, String bankLogin, boolean isOFDReceipt) {
        boolean existed;
        ArrayList<DownloadListDetail> arrayList = new ArrayList<DownloadListDetail>(16);
        String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
        String bankVersionId = detail.getBankVersionId();
        String accNo = detail.getAccNo();
        String tempPath = FileStorageUtil.getFileBakPath((String)detail.getBankVersionId()) + File.separator + transDateStr;
        String unZipDir = FileStorageUtil.getFileBatchBakPathByTransDate((String)detail.getBankVersionId(), (String)transDateStr);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)transDateStr);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        String ftpPath = bankFtpProperties.getFtpPath();
        ftpPath = EBGStringUtils.isNotEmpty((String)ftpPath) ? ftpPath : "/";
        String batchFileName = detail.getFileLink();
        File bakFile = FileCommonUtils.getFileByPath((String)bakFilePath);
        String type = "PDF";
        if (isOFDReceipt) {
            type = "OFD";
        }
        PDFFilter fitler = new PDFFilter(accNo, transDateStr, type.toLowerCase(Locale.ENGLISH));
        if (bakFile.exists()) {
            File[] files = bakFile.listFiles(fitler);
            logger.info("\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u4e0b\u8f7d\u672c\u5730\u5df2\u5b58\u5728\u56de\u5355\u6587\u4ef6-\u6587\u4ef6\u4e2a\u6570:{}-{}", new Object[]{files.length, accNo});
            if (files != null && files.length > 0) {
                for (File file : files) {
                    DownloadListDetail listDetail = new DownloadListDetail();
                    listDetail.setFileName(file.getName());
                    listDetail.setFileLink(batchFileName);
                    listDetail.setBankFilePath(bakFilePath + File.separator + file.getName());
                    arrayList.add(listDetail);
                }
                return arrayList;
            }
        }
        if (existed = FileCommonUtils.getFileByPath((String)tempPath, (String)batchFileName).exists()) {
            if (batchFileName.toLowerCase(Locale.ENGLISH).contains("pdf")) {
                File file = FileCommonUtils.getFileByPath((String)(tempPath + File.separator + batchFileName));
                DownloadListDetail listDetail = this.pdfOperation(file, bakFilePath, detail.getFileName());
                arrayList.add(listDetail);
                return arrayList;
            }
            logger.info("\u4e0b\u8f7d\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u6587\u4ef6-\u56de\u5355\u6587\u4ef6\u5df2\u5b58\u5728-\u89e3\u538b\u538b\u7f29\u5305-{}-{}-{}", new Object[]{accNo, transDateStr, batchFileName});
            GZFileUtils.unZipFiles((String)(tempPath + File.separator + batchFileName), (String)unZipDir);
        } else {
            boolean isPdf = batchFileName.toLowerCase(Locale.ENGLISH).contains(".pdf");
            String realAccNoReceiptPath = unZipDir + File.separator + accNo;
            File accNoReceiptPath = FileCommonUtils.getFileByPath((String)realAccNoReceiptPath);
            if (!isPdf && accNoReceiptPath.exists() && accNoReceiptPath.listFiles().length > 0) {
                logger.info("\u4e0b\u8f7d\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u6587\u4ef6-\u56de\u5355\u6587\u4ef6\u5df2\u5b58\u5728-{}-{}-{}", new Object[]{accNo, transDateStr, batchFileName});
                return this.handleUnZipPath(realAccNoReceiptPath, bakFilePath, accNo, transDateStr, batchFileName, fitler);
            }
            boolean flag = false;
            ChannelSftp sftp = null;
            if (batchFileName.isEmpty()) throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u603b\u5305\u6587\u4ef6\u540d\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]));
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp();
                }
                logger.info("\u4e0b\u8f7d\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u6587\u4ef6-SFTP\u65b9\u5f0f-{}-{}-{}", new Object[]{accNo, transDateStr, batchFileName});
                flag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, batchFileName, tempPath, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                logger.info("\u4e0b\u8f7d\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u6587\u4ef6-\u524d\u7f6e\u673a\u65b9\u5f0f-{}-{}-{}", new Object[]{accNo, transDateStr, batchFileName});
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, detail.getTransDate());
                flag = bankReceiptApiUtil.downloadReceiptFile(batchFileName, tempPath);
            }
            if (!flag) throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u603b\u5305\u6587\u4ef6\u540d\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]));
            File file = FileCommonUtils.getFileByPath((String)(tempPath + File.separator + batchFileName));
            if (isPdf) {
                DownloadListDetail listDetail = this.pdfOperation(file, bakFilePath, detail.getFileName());
                arrayList.add(listDetail);
                return arrayList;
            }
            GZFileUtils.unZipFiles((String)(tempPath + File.separator + batchFileName), (String)unZipDir);
        }
        unZipDir = unZipDir + File.separator + accNo;
        logger.info("\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u4e0b\u8f7d\u672c\u5730\u5df2\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6-\u6587\u4ef6\u5b58\u653e\u76ee\u5f55:{}-{}-{}", new Object[]{accNo, transDateStr, unZipDir});
        List<DownloadListDetail> list = this.handleUnZipPath(unZipDir, bakFilePath, accNo, transDateStr, batchFileName, fitler);
        File totalFile = FileCommonUtils.getFileByPath((String)tempPath, (String)batchFileName);
        if (!totalFile.exists()) return list;
        boolean isDelete = totalFile.delete();
        logger.info("\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u4e0b\u8f7d-\u5220\u9664\u603b\u5305-{}-{}-{}", new Object[]{accNo, batchFileName, isDelete});
        return list;
    }

    public List<DownloadListDetail> handleUnZipPath(String unZipDir, String bakFilePath, String accNo, String transDateStr, String batchFileName, PDFFilter fitler) {
        File unZipFile = FileCommonUtils.getFileByPath((String)unZipDir);
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        if (unZipFile.exists()) {
            File[] files = unZipFile.listFiles(fitler);
            logger.info("\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248-\u975e\u4e3b\u52a8\u63a8\u9001\u6a21\u5f0f-\u7b5b\u9009\u5230\u7684\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a{}", (Object)files.length);
            ArrayList<String> fileList = new ArrayList<String>(16);
            if (files.length > 0) {
                for (int j = 0; j < files.length; ++j) {
                    fileList.add(files[j].getName());
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    downloadListDetail.setFileName(files[j].getName());
                    downloadListDetail.setFileName(files[j].getName());
                    downloadListDetail.setFileLink(batchFileName);
                    downloadListDetail.setBankFilePath(bakFilePath + File.separator + files[j].getName());
                    detailList.add(downloadListDetail);
                }
            }
            for (String receiptName : fileList) {
                File sourceFile = FileCommonUtils.getFileByPath((String)(unZipDir + File.separator + receiptName));
                if (!sourceFile.exists() || !FileCommonUtils.moveFile((File)sourceFile, (String)bakFilePath, (String)sourceFile.getName())) continue;
                boolean isDelete = sourceFile.delete();
                logger.info("\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u4e0b\u8f7d-\u5220\u9664\u603b\u5305-{}-{}-{}-{}", new Object[]{accNo, transDateStr, sourceFile.getName(), isDelete});
            }
            File accFile = FileCommonUtils.getFileByPath((String)unZipDir);
            if (accFile.exists() && accFile.isDirectory() && accFile.listFiles().length == 0) {
                boolean isDelete = accFile.delete();
                logger.info("\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248-\u5f53\u524d\u76ee\u5f55\uff1a{}-{} \u56de\u5355\u6587\u4ef6\u5df2\u7ecf\u5168\u90e8\u8f6c\u79fb\u9700\u8981\u5220\u9664\u8be5\u76ee\u5f55...", new Object[]{unZipDir, isDelete});
            }
        }
        if (detailList.size() == 0) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u94f6\u884c\u8d26\u53f7[%1$s]\u5728\u4ea4\u6613\u65e5\u671f%2$s\u7684\u56de\u5355\u6587\u4ef6", (String)"BankReceiptDownloadImpl_6", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), accNo, transDateStr));
        }
        return detailList;
    }

    public DownloadListDetail pdfOperation(File file, String filePath, String fileName) {
        FileCommonUtils.moveFile((File)file, (String)filePath, (String)fileName);
        DownloadListDetail listDetail = new DownloadListDetail();
        listDetail.setFileName(fileName);
        listDetail.setFileLink(filePath);
        return listDetail;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ABC_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]);
    }
}

