/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.abc.dc.service.receipt.util;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.FileInfo;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class ReceiptPacker {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptPacker.class);

    public static String pack(String transCode, String transDate, String corpNo, String opNo, String charset) {
        Element root = ReceiptPacker.createABCRoot4New(transCode, corpNo, opNo);
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"StartDate", (String)transDate);
        JDomUtils.addChild((Element)corp, (String)"AlterFlag", (String)"1");
        return ReceiptPacker.covert2ABCMessage(root, charset);
    }

    public static String detailRequestPack(String transCode, String corpNo, String opNo, String dbProv, String accNo, String transDate, String charset, String bankCurrency) {
        Element root = ReceiptPacker.createABCRoot4New(transCode, corpNo, opNo);
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"StartDate", (String)transDate);
        JDomUtils.addChild((Element)corp, (String)"EndDate", (String)transDate);
        Element channel = JDomUtils.addChild((Element)root, (String)"Channel");
        JDomUtils.addChild((Element)channel, (String)"LastJrnNo", (String)"0");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)accNo);
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)dbProv);
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)bankCurrency);
        JDomUtils.addChild((Element)cmp, (String)"StartTime", (String)"");
        return ReceiptPacker.covert2ABCMessage(root, charset);
    }

    public static String todayReceiptRequestPack(String transCode, String corpNo, String opNo, String accNo, String transDate, String charset, FileInfo info) {
        String prov = info.getProv();
        String cur = info.getCur();
        String trJrn = info.getTrJrn();
        String oppProv = info.getOppProv();
        String oppAccNo = info.getOppAccNo();
        String oppCur = info.getOppCur();
        String amt = info.getAmt();
        Element root = ReceiptPacker.createABCRoot4New(transCode, corpNo, opNo);
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)prov);
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)accNo);
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)cur);
        JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)oppProv);
        JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)oppAccNo);
        JDomUtils.addChild((Element)cmp, (String)"CrCur", (String)oppCur);
        JDomUtils.addChild((Element)cmp, (String)"TrDate", (String)transDate);
        JDomUtils.addChild((Element)cmp, (String)"JrnNo", (String)trJrn);
        JDomUtils.addChild((Element)root, (String)"Amt", (String)amt);
        return ReceiptPacker.covert2ABCMessage(root, charset);
    }

    public static Element createABCRoot4New(String transCode, String corpNo, String opNo) {
        Element element = new Element("ap");
        JDomUtils.addChild((Element)element, (String)"CCTransCode", (String)transCode);
        JDomUtils.addChild((Element)element, (String)"ProductID", (String)"ICC");
        JDomUtils.addChild((Element)element, (String)"ChannelType", (String)"ERP");
        JDomUtils.addChild((Element)element, (String)"CorpNo", (String)corpNo);
        JDomUtils.addChild((Element)element, (String)"OpNo", (String)opNo);
        JDomUtils.addChild((Element)element, (String)"AuthNo", (String)"");
        JDomUtils.addChild((Element)element, (String)"ReqSeqNo", (String)(Sequence.genSequence() + ""));
        JDomUtils.addChild((Element)element, (String)"ReqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)element, (String)"ReqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)element, (String)"Sign", (String)"");
        return element;
    }

    private static String covert2ABCMessage(Element root, String charset) {
        String xml = "";
        try {
            xml = ReceiptPacker.appendABCHead(JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)charset), charset);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return xml;
    }

    private static String appendABCHead(String str, String charset) {
        byte[] bytes = StrUtil.bytes((CharSequence)str, (String)charset);
        String head = StrUtil.padEnd((CharSequence)("0" + bytes.length), (int)7, (char)' ');
        return head + str;
    }
}

