/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.abc.dc.service.receipt.util;

import com.jcraft.jsch.ChannelSftp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.FileInfo;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class ReceiptParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptParser.class);

    public static Element parseString2Root(String rspStr, String encoding) {
        rspStr = rspStr.substring(7);
        Element root = JDomUtils.str2Doc((String)rspStr, (String)encoding).getRootElement();
        return root;
    }

    public static List<FileInfo> detailResponseParser(DownloadListTask task, String response) {
        ArrayList<FileInfo> fileInfos = new ArrayList(16);
        if (StringUtils.isEmpty((String)response)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a", (String)"ReceiptParser_0", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]));
        }
        response = response.substring(7);
        Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
        String respCode = root.getChildTextTrim("RespCode");
        String respInfo = root.getChildTextTrim("RespInfo");
        String rxtInfo = root.getChildTextTrim("RxtInfo");
        if (PropertiesConstantsUtils.getValue((String)"TRANS_SUCCESS").equals(respInfo)) {
            String FileFlag = JDomUtils.getUnNullChildTextTrim((Element)root, (String)"FileFlag");
            if ("0".equals(FileFlag)) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\uff1a\u65e0\u6587\u4ef6\uff0c\u65e0\u8bb0\u5f55\u3002", (String)"ReceiptParser_2", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]));
            }
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1aRespInfo:%1$s ,RespCode: %2$s, RxtInfo:%3$s", (String)"ReceiptParser_9", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), respInfo, respCode, rxtInfo));
        }
        Element cmp = root.getChild("Cmp");
        String batchFileName = JDomUtils.getUnNullChildTextTrim((Element)cmp, (String)"BatchFileName");
        fileInfos = ReceiptParser.fileDownloadAndparse(task, batchFileName);
        return fileInfos;
    }

    public static List<FileInfo> fileDownloadAndparse(DownloadListTask task, String batchFileName) {
        List<FileInfo> fileInfos = new ArrayList<FileInfo>();
        boolean downloadFlag = false;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, task.getBankLoginId());
        String ftpPath = bankFtpProperties.getFtpPath();
        String tempPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"ABC_DC", (String)task.getAccNo(), (String)LocalDateUtil.formatDate((LocalDate)task.getTransDate()));
        logger.info("\u519c\u4e1a\u94f6\u884c\u51c6\u5907\u53bb\u670d\u52a1\u5668\u4e0b\u8f7d\u6982\u8981\u6587\u4ef6:" + batchFileName);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            downloadFlag = ReceiptParser.ftpDownload(task.getBankLoginId(), EBGStringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath, batchFileName, tempPath);
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            downloadFlag = ReceiptParser.frontProxyDownload(batchFileName, task.getAccNo(), task.getTransDate());
        }
        if (downloadFlag) {
            logger.info("\u4e0b\u8f7d\u6587\u4ef6" + batchFileName + "\u6210\u529f..");
            File sourceFile = FileCommonUtils.getFileByPath((String)(tempPath + File.separator + batchFileName));
            fileInfos = ReceiptParser.parseFileContent(sourceFile);
        }
        return fileInfos;
    }

    private static List<FileInfo> parseFileContent(File sourceFile) {
        ArrayList<FileInfo> fileInfos;
        block20: {
            fileInfos = new ArrayList<FileInfo>(16);
            if (sourceFile.exists()) {
                try (FileInputStream totalFileStream = new FileInputStream(sourceFile);){
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)totalFileStream, "GBK"));
                    String fileContent = "";
                    while ((fileContent = bufferedReader.readLine()) != null) {
                        String prov = fileContent.split("\\|")[0];
                        String cur = fileContent.split("\\|")[2];
                        String trJrn = fileContent.split("\\|")[5];
                        String oppProv = fileContent.split("\\|")[10];
                        String oppAccNo = fileContent.split("\\|")[11];
                        String oppCur = fileContent.split("\\|")[12];
                        String amt = fileContent.split("\\|")[18];
                        FileInfo info = new FileInfo();
                        info.setProv(prov);
                        info.setCur(cur);
                        info.setTrJrn(trJrn);
                        info.setOppProv(oppProv);
                        info.setOppAccNo(oppAccNo);
                        info.setCur(oppCur);
                        info.setAmt(amt);
                        fileInfos.add(info);
                    }
                    logger.info("\u8bfb\u53d6\u6982\u8981\u6587\u4ef6" + sourceFile + "\u5b8c\u6210");
                    break block20;
                }
                catch (Exception e) {
                    String msg = String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6982\u8981\u6587\u4ef6\uff1a%1$s;\u5f02\u5e38:%2$s", (String)"ReceiptParser_15", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), sourceFile.getName(), e.getMessage());
                    throw new ReceiptException(msg, (Throwable)e);
                }
                finally {
                    if (sourceFile.delete()) {
                        logger.info("\u6982\u8981\u6587\u4ef6" + sourceFile + "\u5220\u9664\u6210\u529f");
                    }
                }
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6982\u8981\u6587\u4ef6%s\u4e0d\u5b58\u5728\u3002\u8bf7\u548c\u94f6\u884c\u786e\u8ba4\u63a8\u9001\u8def\u5f84\uff0c\u548c\u94f6\u884c\u662f\u5426\u63a8\u9001\u6587\u4ef6\u3002", (String)"ReceiptParser_14", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), sourceFile.getName()));
        }
        return fileInfos;
    }

    private static boolean frontProxyDownload(String orgFileName, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.downloadReceiptFile(orgFileName);
    }

    private static boolean ftpDownload(String bankLogin, String ftpPath, String orgFileName, String destFolder) {
        ChannelSftp sftp = null;
        boolean downloadFlag = false;
        try {
            Vector vector;
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLogin);
            }
            if (sftp != null && Objects.nonNull(vector = sftp.ls(ftpPath)) && vector.size() > 0) {
                for (Object o : vector) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)o;
                    if (!file.getFilename().equals(orgFileName)) continue;
                    downloadFlag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
                }
            }
        }
        catch (Exception e) {
            try {
                String msg = ErrorMsgUtil.getSFTPErrorMSG((String)"", (String)e.getMessage());
                throw new ReceiptException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        SFTPUtils.getInstance().close(sftp);
        return downloadFlag;
    }

    public static String todayReceiptResponseParse(String response, String encoding) {
        response = response.substring(7);
        Element root = JDomUtils.str2Doc((String)response, (String)encoding).getRootElement();
        String respCode = root.getChildTextTrim("RespCode");
        String respInfo = root.getChildTextTrim("RespInfo");
        String rxtInfo = root.getChildTextTrim("RxtInfo");
        if ("0000".equals(respCode)) {
            String FileFlag = JDomUtils.getUnNullChildTextTrim((Element)root, (String)"FileFlag");
            if ("0".equals(FileFlag)) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\uff1a\u65e0\u6587\u4ef6\uff0c\u65e0\u8bb0\u5f55\u3002", (String)"ReceiptParser_2", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]));
            }
            Element cmp = root.getChild("Cmp");
            String batchFileName = JDomUtils.getUnNullChildTextTrim((Element)cmp, (String)"BatchFileName");
            return batchFileName;
        }
        if ("9999".equals(respCode) || respInfo.contains(PropertiesConstantsUtils.getValue((String)"END_MASTER_CONNECT"))) {
            return null;
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1aRespInfo: %1$s ,RespCode:%2$s , RxtInfo: %3$s", (String)"ReceiptParser_13", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), respInfo, respCode, rxtInfo));
    }
}

