/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zsb.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zsb.dc.service.receipt.ZsbDcCommConfig;
import kd.ebg.receipt.banks.zsb.dc.service.receipt.api.ZsbBankReceiptRequestImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        ArrayList<DownloadListDetail> result;
        block6: {
            this.init(bankReceiptHandleRequest);
            long taskId = bankReceiptHandleRequest.getTaskId();
            DownloadListTask task = this.downloadTaskService.findById(taskId);
            result = new ArrayList<DownloadListDetail>(16);
            String accNo = task.getAccNo();
            LocalDate transDate = task.getTransDate();
            String bankLogin = EBContext.getContext().getBankLoginID();
            try {
                BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
                logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
                logger.info("\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6");
                ArrayList<String> detailFileNames = new ArrayList<String>(1);
                String bankCurrency = bankReceiptHandleRequest.getAcnt().getCurrency();
                logger.info("\u67e5\u8be2\u7684\u94f6\u884c\u5e01\u79cd\u4ee3\u7801\u4e3a\uff1a{}", (Object)bankCurrency);
                detailFileNames.addAll(this.getDetails(accNo, transDate, 1, "", bankCurrency));
                logger.info("\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u540d\uff1a" + ((Object)detailFileNames).toString());
                if (detailFileNames.size() == 0) {
                    throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]));
                }
                logger.info("\u83b7\u53d6\u56de\u5355\u53f7");
                List<String> receiptNos = this.getReceiptNo(detailFileNames, ftpProperties, accNo, transDate);
                logger.info("\u83b7\u53d6\u56de\u5355");
                List<String> receiptNames = this.getReceipts(accNo, transDate, receiptNos);
                String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                if (receiptNames != null && receiptNames.size() != 0) {
                    for (String receiptName : receiptNames) {
                        DownloadListDetail downloadListDetail = new DownloadListDetail();
                        downloadListDetail.setFileLink(receiptName);
                        downloadListDetail.setFileName(accNo + "-" + date + "-" + receiptName);
                        result.add(downloadListDetail);
                    }
                    break block6;
                }
                throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u5217\u8868\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    private List<String> getReceiptNo(List<String> detailFileNames, BankFtpProperties ftpProperties, String accNo, LocalDate transDate) {
        ArrayList<String> receiptNos = new ArrayList<String>(16);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"ZSB_DC", (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        for (String fileName : detailFileNames) {
            int i;
            ChannelSftp sftp;
            ArrayList<String> detailLines;
            block37: {
                detailLines = new ArrayList<String>(16);
                sftp = null;
                try {
                    if (ftpProperties.getReceiptAchieveWay().equals("sftp")) {
                        if (SFTPUtils.getInstance().isAbort(sftp)) {
                            sftp = SFTPUtils.getInstance().getSftp();
                        }
                        if (sftp == null) {
                            throw new ReceiptException(ResManager.loadKDString((String)"SFTP\u8fde\u63a5\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_3", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]));
                        }
                        String ftpPath = ftpProperties.getFtpPath();
                        ftpPath = EBGStringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath;
                        logger.info("\u6d59\u5546\u94f6\u884c-sftp\u76ee\u5f55\uff1a{}", (Object)ftpPath);
                        Vector ftpFiles = sftp.ls(ftpPath);
                        logger.info("\u6d59\u5546\u94f6\u884c-sftp\u76ee\u5f55:{}-\u4e0b\u6587\u4ef6\u6570\uff1a{}-\u5f53\u524d\u65f6\u95f4\uff1a{}-\u5f85\u67e5\u627e\u7684\u6587\u4ef6\u540d\uff1a{}", new Object[]{ftpPath, ftpFiles.size(), LocalDateTime.now(), fileName});
                        if (ftpFiles != null && ftpFiles.size() > 0) {
                            Iterator iterator = ftpFiles.iterator();
                            while (iterator.hasNext()) {
                                String tempString;
                                ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)iterator.next();
                                if (!Objects.equals(lsEntry.getFilename(), fileName) && !lsEntry.getFilename().contains(fileName)) continue;
                                sftp.cd(ftpPath);
                                logger.info("\u6d59\u5546\u94f6\u884c-\u5207\u6362\u5230sftp\u76ee\u5f55:{}-\u4e0b\u6587\u4ef6\u540d\uff1a{}", new Object[]{ftpPath, lsEntry.getFilename()});
                                InputStream retrieveFileStream = sftp.get(lsEntry.getFilename());
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(retrieveFileStream, "GBK"));
                                while ((tempString = bufferedReader.readLine()) != null) {
                                    detailLines.add(tempString);
                                }
                            }
                        }
                        break block37;
                    }
                    if (!ftpProperties.getReceiptAchieveWay().equals("bank_login")) break block37;
                    List<String> filenames = this.getFilenames(fileName, accNo, transDate);
                    for (String filename : filenames) {
                        boolean flag = this.downloadByFileName(filename, accNo, transDate);
                        if (flag) {
                            File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                            if (file.exists()) {
                                FileInputStream retrieveFileStream = new FileInputStream(file);
                                Throwable throwable = null;
                                try {
                                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)retrieveFileStream, "GBK"));
                                    Throwable throwable2 = null;
                                    try {
                                        String tempString;
                                        while ((tempString = bufferedReader.readLine()) != null) {
                                            detailLines.add(tempString);
                                        }
                                        boolean isDelete = file.delete();
                                        logger.info("\u6587\u4ef6\u540d\uff1a{}-\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
                                        continue;
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        if (bufferedReader == null) continue;
                                        if (throwable2 != null) {
                                            try {
                                                bufferedReader.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable2.addSuppressed(throwable4);
                                            }
                                            continue;
                                        }
                                        bufferedReader.close();
                                        continue;
                                    }
                                }
                                catch (Throwable throwable5) {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    if (retrieveFileStream == null) continue;
                                    if (throwable != null) {
                                        try {
                                            ((InputStream)retrieveFileStream).close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                        continue;
                                    }
                                    ((InputStream)retrieveFileStream).close();
                                    continue;
                                }
                            }
                            throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u53f7\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]));
                        }
                        throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u53f7\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    try {
                        logger.error("\u6d59\u5546\u94f6\u884c-SFTP\u5f02\u5e38", (Throwable)e);
                        throw new ReceiptException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SFTPUtils.getInstance().close(sftp);
                        throw throwable;
                    }
                }
            }
            SFTPUtils.getInstance().close(sftp);
            logger.info("\u6587\u4ef6\u5185\u5bb9\uff1a" + detailLines);
            String title = (String)detailLines.get(0);
            String[] columns = title.split("\\|");
            int index = 0;
            for (i = 0; i < columns.length; ++i) {
                if (!columns[i].startsWith("serial_no")) continue;
                index = i;
                break;
            }
            for (i = 1; i < detailLines.size(); ++i) {
                String detailLine = (String)detailLines.get(i);
                columns = detailLine.split("\\|");
                receiptNos.add(columns[index]);
            }
        }
        return receiptNos;
    }

    private List<String> getFilenames(String orgFileName, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(orgFileName);
    }

    private boolean downloadByFileName(String orgFileName, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.downloadReceiptFile(orgFileName);
    }

    private List<String> getReceipts(String accNo, LocalDate transDate, List<String> receiptNos) {
        ArrayList<String> fileNames = new ArrayList<String>(16);
        String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (receiptNos != null && receiptNos.size() != 0) {
            for (String receiptNo : receiptNos) {
                String request = this.packReceiptRequest(accNo, date, receiptNo);
                logger.info("\u56de\u5355\u4e0b\u8f7d-\u8bf7\u6c42\u62a5\u6587\uff1a\n" + request);
                ZsbBankReceiptRequestImpl zsbBankReceiptRequest = new ZsbBankReceiptRequestImpl();
                BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(request).accNo(accNo).transDate(transDate).build();
                BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)zsbBankReceiptRequest.doBiz((BankRequest)bankReceiptRequest);
                String response = (String)receiptResponseEB.getData();
                logger.info("\u56de\u5355\u4e0b\u8f7d-\u54cd\u5e94\u62a5\u6587\uff1a\n" + response);
                String fileName = this.parseReceiptResponse(response);
                fileNames.add(fileName);
            }
        }
        return fileNames;
    }

    private List<String> getDetails(String accNo, LocalDate transDate, Integer pageNo, String totalFileName, String bankCurrency) {
        String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String request = this.packDetailRequest(accNo, date, pageNo, totalFileName, bankCurrency);
        logger.info("\u4ea4\u6613\u660e\u7ec6\u83b7\u53d6-\u8bf7\u6c42\u62a5\u6587-{}-{}\uff1apage:{}-{}", new Object[]{accNo, transDate, pageNo, request});
        ZsbBankReceiptRequestImpl zsbBankReceiptRequest = new ZsbBankReceiptRequestImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(request).accNo(accNo).transDate(transDate).build();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)zsbBankReceiptRequest.doBiz((BankRequest)bankReceiptRequest);
        String response = (String)receiptResponseEB.getData();
        logger.info("\u4ea4\u6613\u660e\u7ec6\u83b7\u53d6-\u54cd\u5e94\u62a5\u6587-{}-{}\uff1apage:{}-{}", new Object[]{accNo, transDate, pageNo, response});
        response = response.substring(response.indexOf("<"));
        Document document = JDomUtils.str2DocGBK((String)response);
        Element root = document.getRootElement();
        Element head = root.getChild("head");
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");
        String file_flag = head.getChildTextTrim("file_flag");
        ArrayList<String> fileNames = new ArrayList<String>(16);
        if (!"0_0000".equals(succ_flag + "_" + ret_code)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s_%2$s\uff0c\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a%3$s;\u94f6\u884c\u8fd4\u56de\u9644\u52a0\u4fe1\u606f\u4e3a\uff1a%4$s\u3002", (String)"BankReceiptFetchListImpl_10", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]), succ_flag, ret_code, ret_info, ext_info));
        }
        if ("0".equals(file_flag)) {
            return fileNames;
        }
        Element body = root.getChild("body");
        String totalfilename = body.getChildTextTrim("totalfilename");
        String recordNum = body.getChildTextTrim("record_num");
        String totalRecordNum = body.getChildTextTrim("total_record_num");
        String fileName = body.getChildTextTrim("file_name");
        fileNames.add(fileName);
        if ((pageNo - 1) * 10 + Integer.parseInt(recordNum) != Integer.parseInt(totalRecordNum)) {
            List<String> result = this.getDetails(accNo, transDate, pageNo + 1, totalfilename, bankCurrency);
            fileNames.addAll(result);
        }
        return fileNames;
    }

    private String packDetailRequest(String accNo, String transDate, Integer pageNo, String totalFileName, String bankCurrency) {
        Element root = BankReceiptFetchListImpl.buildHead("200112", "1");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)bankCurrency);
        JDomUtils.addChild((Element)body, (String)"start_date", (String)transDate);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)transDate);
        JDomUtils.addChild((Element)body, (String)"pageno", (String)(pageNo + ""));
        JDomUtils.addChild((Element)body, (String)"isReceipt", (String)"1");
        JDomUtils.addChild((Element)body, (String)"totalfilename", (String)totalFileName);
        String xmlStr = BankReceiptFetchListImpl.root2StringWithoutXMLDeclaration(root, "GBK");
        xmlStr = BankReceiptFetchListImpl.buildCommonMsg(xmlStr);
        return xmlStr;
    }

    private String packReceiptRequest(String accNo, String transDate, String receiptNo) {
        Element root = BankReceiptFetchListImpl.buildHead("200120", "0");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"accno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"date", (String)transDate);
        JDomUtils.addChild((Element)body, (String)"query_type", (String)"1");
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)receiptNo);
        String xmlStr = BankReceiptFetchListImpl.root2StringWithoutXMLDeclaration(root, "GBK");
        xmlStr = BankReceiptFetchListImpl.buildCommonMsg(xmlStr);
        return xmlStr;
    }

    private static Element buildHead(String trCode, String fileFlag) {
        Element root = JDomUtils.createRoot((String)"ap");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)trCode);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)((ZsbDcCommConfig)EBConfigBuilder.getInstance().buildConfig(ZsbDcCommConfig.class, bankLoginId)).getCorpNo());
        JDomUtils.addChild((Element)head, (String)"user_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"org_code", (String)"");
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)(Sequence.genSequence() + ""));
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)sdf.format(now));
        sdf = new SimpleDateFormat("HHmmss");
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)sdf.format(now));
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign", (String)"0");
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)fileFlag);
        JDomUtils.addChild((Element)head, (String)"reserved", (String)"");
        return root;
    }

    private static String root2StringWithoutXMLDeclaration(Element root, String encoding) {
        XMLOutputter outputter = new XMLOutputter();
        Format newFormat = Format.getPrettyFormat();
        newFormat.setEncoding(encoding);
        newFormat.setIndent("    ");
        newFormat.setExpandEmptyElements(true);
        outputter.setFormat(newFormat);
        return outputter.outputString(root);
    }

    private String parseReceiptResponse(String response) {
        response = response.substring(response.indexOf("<"));
        Document document = JDomUtils.str2DocGBK((String)response);
        Element root = document.getRootElement();
        Element head = root.getChild("head");
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");
        if (!"0_0000".equals(succ_flag + "_" + ret_code)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s_%2$s\uff0c\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a%3$s;\u94f6\u884c\u8fd4\u56de\u9644\u52a0\u4fe1\u606f\u4e3a\uff1a%4$s\u3002", (String)"BankReceiptFetchListImpl_11", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]), succ_flag, ret_code, ret_info, ext_info));
        }
        Element body = root.getChild("body");
        String fileLink = body.getChildTextTrim("file_name");
        return fileLink;
    }

    public static String buildCommonMsg(String xmlStr) {
        int length = BankReceiptFetchListImpl.getLength(xmlStr);
        StringBuilder buffer = new StringBuilder();
        String str = BankReceiptFetchListImpl.formatLen(Integer.toString(length + 2));
        buffer.append(str);
        buffer.append("00");
        buffer.append(xmlStr);
        return buffer.toString();
    }

    private static int getLength(String msg) {
        try {
            return msg.getBytes("GBK").length;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u62a5\u6587\u5934+\u62a5\u6587\u4f53\u957f\u5ea6\u662f\u51fa\u9519\uff0c", (Object)e);
            return 0;
        }
    }

    private static String formatLen(String orgStr) {
        try {
            return EBGStringUtils.formatLen((String)orgStr, (int)10, (boolean)false, (char)' ', (String)"GBK");
        }
        catch (Exception e) {
            logger.info("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\uff0c", (Object)e);
            return "";
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PAB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u6d59\u5546\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_9", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

