/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zsb.dc.service.receipt.api;

import java.io.InputStream;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class ZsbBankReceiptRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ZsbBankReceiptRequestImpl.class);

    public String pack(BankReceiptRequest request) {
        String bankVersionId = EBContext.getContext().getBankVersionID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String requestStr = request.getRequestStr();
        return requestStr;
    }

    public String recv(InputStream inputStream) {
        return ZsbBankReceiptRequestImpl.parseRecvMsg(super.recv(inputStream));
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String bankVersionId = EBContext.getContext().getBankVersionID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        return BankReceiptResponseEB.success((Object)responseStr);
    }

    public static String parseRecvMsg(String input) {
        if (!StringUtils.isEmpty((String)input)) {
            return input.substring(12);
        }
        return "";
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ZSB_BANK_RECEIPT_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d59\u5546\u94f6\u884c\u56de\u5355\u63a5\u53e3\u8bf7\u6c42\u3002", (String)"ZsbBankReceiptRequestImpl_0", (String)"ebg-receipt-banks-zsb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setProtocol("tcp");
    }
}

