/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccqtgb.dc.service.helper;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.ccqtgb.dc.service.helper.BankCode;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.utils.ParserUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DC_ResponseParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DC_ResponseParser.class);

    public static BankResponse parserCommonHead(String xmlDoc) {
        List childs;
        BankResponse response = new BankResponse();
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)xmlDoc, (String)encoding);
        Element headEle = root.getChild("Head");
        if (headEle == null) {
            headEle = root.getChild("head");
        }
        if ((childs = headEle.getChildren()).size() < 2) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"head\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\u3002", (String)"DC_ResponseParser_0", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]));
        }
        response.setResponseCode(headEle.getChildTextTrim("IBSReturnCode"));
        response.setResponseMessage(headEle.getChildTextTrim("IBSReturnMsg"));
        logger.info("===parserCommonHead\uff1a" + headEle.getChildTextTrim("IBSReturnCode"));
        return response;
    }

    public static List<DetailInfo> parserDeatilsMessage(BankDetailRequest bqst, String rspStr) {
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element bodyEle = root.getChild("Body");
        List resList = bodyEle.getChildren("List");
        Element map = ((Element)resList.get(0)).getChild("Map");
        String returnCode = map.getChildText("ReturnCode");
        String accNo = map.getChildText("AcNo");
        BankAcnt paramBankAcnt = bqst.getAcnt();
        if (!BankCode.SUCCESS_CODE.equalsIgnoreCase(returnCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u5185\u5c42\u72b6\u6001\u7801\uff1a%s\u3002", (String)"DC_ResponseParser_7", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]), returnCode);
            logger.error(errorMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        if (!paramBankAcnt.getAccNo().equalsIgnoreCase(accNo)) {
            logger.error("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u8d26\u53f7\u8ddf\u4e0a\u9001\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u4e0a\u9001\u8d26\u53f7{}\uff0c\u54cd\u5e94\u8d26\u53f7{}", new Object[]{paramBankAcnt.getAccNo(), accNo});
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u8d26\u53f7\u8ddf\u4e0a\u9001\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"DC_ResponseParser_2", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]));
        }
        ArrayList<DetailInfo> infos = new ArrayList<DetailInfo>(16);
        Element list = map.getChild("List");
        if (list == null) {
            return infos;
        }
        List detailList = list.getChildren("Map");
        if (!detailList.isEmpty()) {
            for (Element detail : detailList) {
                String PartnerAcct = detail.getChildText("PartnerAcct");
                String PartnerAcName = detail.getChildText("PartnerAcName");
                String DCFlag = detail.getChildText("DCFlag");
                String Amount = detail.getChildText("Amount");
                String TransDate = detail.getChildText("TransDate");
                String TransTime = detail.getChildText("TransTime");
                String Remark = detail.getChildText("Remark");
                String TrsJnlNo = detail.getChildText("TrsJnlNo");
                DetailInfo info = new DetailInfo();
                info.setAccName(paramBankAcnt.getAccName());
                info.setAccNo(paramBankAcnt.getAccNo());
                info.setBankName(paramBankAcnt.getBankName());
                info.setOppAccNo(PartnerAcct);
                info.setOppAccName(PartnerAcName);
                if (StringUtils.isEmpty((String)Amount)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a", (String)"DC_ResponseParser_3", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]));
                }
                BigDecimal amout = new BigDecimal(Amount.trim());
                if ("D".equalsIgnoreCase(DCFlag)) {
                    info.setDebitAmount(amout);
                    info.setCreditAmount(ParserUtils.ZERO);
                } else if ("C".equalsIgnoreCase(DCFlag)) {
                    info.setDebitAmount(ParserUtils.ZERO);
                    info.setCreditAmount(amout);
                } else {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7DCFlag=%s\u3002", (String)"DC_ResponseParser_8", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]), DCFlag));
                }
                info.setTransDate(LocalDate.parse(TransDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                info.setTransTime(LocalDateTime.parse(TransDate + TransTime, DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss")));
                info.setPayBankDetailSeqID(TrsJnlNo);
                info.setReversed1(Amount);
                info.setReversed2(DCFlag);
                infos.add(info);
            }
        }
        return infos;
    }

    public static String parserReceiptMessage(String rspStr) {
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element bodyEle = root.getChild("Body");
        List resList = bodyEle.getChildren("List");
        Element map = ((Element)resList.get(0)).getChild("Map");
        String returnCode = map.getChildText("ReturnCode");
        String returnMsg = map.getChildText("ReturnMsg");
        String base64Str = map.getChildText("Base64Str");
        if (!BankCode.SUCCESS_CODE.equalsIgnoreCase(returnCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u56de\u5355\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u5185\u5c42\u72b6\u6001\u7801\uff1a%s\u3002", (String)"DC_ResponseParser_9", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]), returnCode);
            logger.error(errorMsg);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"B2EElectronicReceiptDownload\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u94f6\u884c\u63a5\u53e3\u54cd\u5e94\u7801\uff1a%1$s \u63a5\u53e3\u54cd\u5e94\u63cf\u8ff0: %2$s\u3002", (String)"DC_ResponseParser_10", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]), returnCode, returnMsg));
        }
        return base64Str;
    }
}

