/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hbb.dc.service.receipt;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.hbb.dc.service.receipt.api.BankReceiptFileDownloadRequestImpl;
import kd.ebg.receipt.banks.hbb.dc.service.receipt.api.BankReceiptInfoQueryImpl;
import kd.ebg.receipt.banks.hbb.dc.service.receipt.util.ReponsePars;
import kd.ebg.receipt.banks.hbb.dc.service.receipt.util.RequestPack;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankReceiptInfoQueryImpl iBankReceipt = new BankReceiptInfoQueryImpl();
        List detailInfos = iBankReceipt.queryTransDetail(accNo, transDate, transDate);
        for (DetailInfo detailInfo : detailInfos) {
            String Jnlno = detailInfo.getReceiptNo();
            String amount = detailInfo.getReversed1();
            String pdfFileName = detailInfo.getReversed2();
            String newFileName = accNo + "_" + transDateStr + "_" + Jnlno + "_" + amount + ".pdf";
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(pdfFileName);
            detail.setFileName(newFileName);
            detail.setReceiptJson(detailInfo.getJson());
            result.add(detail);
        }
        String receiptDownloadStr = RequestPack.receiptDownload(accNo, transDateStr);
        BankReceiptFileDownloadRequestImpl receiptFileDownload = new BankReceiptFileDownloadRequestImpl();
        BankReceiptRequest receiptRequest = BankReceiptRequest.builder().requestStr(receiptDownloadStr).transDate(transDate).accNo(accNo).build();
        BankReceiptResponseEB responseEB = (BankReceiptResponseEB)receiptFileDownload.doBiz((BankRequest)receiptRequest);
        String receiptDownloadResponse = (String)responseEB.getData();
        if (ReponsePars.receiptParser(receiptDownloadResponse)) {
            log.info("\u56de\u5355\u6587\u4ef6\u8bf7\u6c42\u6210\u529f");
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-hbb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "HBB_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u6cb3\u5317\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-hbb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

