/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bochk.dc.service.utils;

import java.util.Date;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BOCHK_DC_Packer {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BOCHK_DC_Packer.class);
    private static int currentCount = 0;
    private static int MAX_VALUE = 999;
    private static String lastDateTime = "";

    public static Element createRootWithHead(String packageId) {
        String CBSAcctNo = RequestContextUtils.getBankParameterValue((String)"CBSAcctNo");
        String UserId = RequestContextUtils.getBankParameterValue((String)"UserId");
        String Password = RequestContextUtils.getBankParameterValue((String)"Password");
        String ECertName = RequestContextUtils.getBankParameterValue((String)"ECertName");
        String ECertPwd = RequestContextUtils.getBankParameterValue((String)"ECertPwd");
        Element root = new Element("BOCHKE2B");
        Element Head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)Head, (String)"PackageId", (String)packageId);
        JDomUtils.addChild((Element)Head, (String)"CBSAcctNo", (String)CBSAcctNo);
        JDomUtils.addChild((Element)Head, (String)"UserId", (String)UserId);
        JDomUtils.addChild((Element)Head, (String)"Password", (String)Password);
        JDomUtils.addChild((Element)Head, (String)"NewPwd", (String)"");
        JDomUtils.addChild((Element)Head, (String)"ConfirmNewPwd", (String)"");
        JDomUtils.addChild((Element)Head, (String)"ECertName", (String)ECertName);
        JDomUtils.addChild((Element)Head, (String)"ECertPwd", (String)ECertPwd);
        return root;
    }

    public static synchronized String getPackageId() {
        String dateTime = BOCHK_DC_Packer.getCurrentDateTime();
        if (!dateTime.equals(lastDateTime)) {
            currentCount = 0;
        }
        if (currentCount == MAX_VALUE) {
            BOCHK_DC_Packer.sleep(1500L);
            dateTime = BOCHK_DC_Packer.getCurrentDateTime();
            currentCount = 0;
        }
        String seqNo3 = String.format("%03d", currentCount);
        String packageId = dateTime + seqNo3;
        lastDateTime = dateTime;
        ++currentCount;
        return packageId;
    }

    private static String getCurrentDateTime() {
        Date now = new Date();
        String date = DateTimeUtils.format((Date)now, (String)"yyyyMMdd");
        String time = DateTimeUtils.format((Date)now, (String)"HHmmss");
        try {
            EBContext context = EBContext.getContext();
            BankLoginConfigKey key = new BankLoginConfigKey();
            key.setBankLoginId(context.getBankLoginID());
            key.setBankVersionId(context.getBankVersionID());
            key.setCustomID(context.getCustomID());
            key.setBankConfigId("packageIDPrefix");
            BankLoginConfig bankLoginConfig = BankLoginConfigService.getInstance().getBankLoginConfig(key);
            if (bankLoginConfig != null && !StringUtils.isEmpty((String)bankLoginConfig.getBankConfigValue())) {
                date = bankLoginConfig.getBankConfigValue();
            }
        }
        catch (IllegalArgumentException | EBServiceException e) {
            logger.error("", e);
        }
        return date + time;
    }

    private static void sleep(long time) {
        if (time < 0L) {
            return;
        }
        try {
            Thread.sleep(time);
        }
        catch (Exception t) {
            logger.error("", (Throwable)t);
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }
}

