/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.czccb.dc.service.receipt.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.api.SignService;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.util.Packer;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class HisDetailPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HisDetailPacker.class);

    public String packDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        BankAcnt backAcnt = rqst.getAcnt();
        String header = Packer.createHeadMessage("CBE010102");
        String body = this.createBody(rqst, backAcnt.getAccNo(), pageTag);
        String reqMsg = header + body;
        String signData = SignService.getSignData(reqMsg, "UTF-8");
        reqMsg = header + body + signData;
        String strLen = Packer.getLength(reqMsg);
        logger.info("\u5c01\u88c5\u7684\u62a5\u6587\u5982\u4e0b\uff1a" + strLen + reqMsg);
        return strLen + reqMsg;
    }

    private String createBody(BankDetailRequest rqst, String accountNo, String pageTag) throws EBServiceException {
        StringBuilder sbBody = new StringBuilder();
        try {
            String encoding = "UTF-8";
            sbBody.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\"?>\r\n");
            sbBody.append("<BankData>");
            sbBody.append("<opReq>");
            sbBody.append("<ReqParam>");
            sbBody.append("<accountNo>").append(accountNo).append("</accountNo>");
            sbBody.append("<turnPageBeginPosTemp>").append(pageTag).append("</turnPageBeginPosTemp>");
            sbBody.append("<turnPageShowNum>").append("50").append("</turnPageShowNum>");
            LocalDate localDate = rqst.getStartDate();
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
            Date date = Date.from(instant);
            sbBody.append("<beginDate>").append(DateTimeUtils.format((Date)date, (String)"yyyyMMdd")).append("</beginDate>");
            localDate = rqst.getEndDate();
            zone = ZoneId.systemDefault();
            instant = localDate.atStartOfDay().atZone(zone).toInstant();
            date = Date.from(instant);
            sbBody.append("<endDate>").append(DateTimeUtils.format((Date)date, (String)"yyyyMMdd")).append("</endDate>");
            sbBody.append("<transferDirection></transferDirection>");
            sbBody.append("<beginAmt>0</beginAmt>");
            sbBody.append("<endAmt>9999999999999</endAmt>");
            sbBody.append("</ReqParam>");
            sbBody.append("</opReq>");
            sbBody.append("</BankData>");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6784\u9020\u5b57\u8282\u6d41\u5931\u8d25%1$s==%2$s", (String)"HisDetailPacker_1", (String)"ebg-receipt-banks-czccb-dc", (Object[])new Object[0]), rqst.getPageNum(), pageTag), (Throwable)e);
        }
        return sbBody.toString();
    }
}

