/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.czccb.dc.service.receipt.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.util.Parser;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class HisDetailParser {
    public List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        List<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(16);
        BankResponse rsp = Parser.parseResponse(rspStr);
        if ("000000".equalsIgnoreCase(rsp.getResponseCode())) {
            detailInfoList = this.getDetail(rspStr, rqst.getAcnt());
        }
        return detailInfoList;
    }

    public List<DetailInfo> getDetail(String rspStr, BankAcnt reqAcnt) throws EBServiceException {
        int index = rspStr.indexOf("#");
        String body = rspStr.substring(index + 1, rspStr.length());
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        try {
            Element bankDate = JDomUtils.string2Root((String)body, (String)"UTF-8");
            Element opRep = bankDate.getChild("opRep");
            Element opResult = opRep.getChild("opResult");
            Element list = opResult.getChild("list");
            List rows = list.getChildren();
            DetailInfo detailInfo = null;
            for (Element row : rows) {
                detailInfo = new DetailInfo();
                String loanFlag = row.getChildText("loanFlag");
                String transferSum = row.getChildText("transferSum");
                String transferFlowNo = row.getChildText("transferFlowNo");
                String seqNo = row.getChildText("seqNo");
                detailInfo.setExplanation(transferSum);
                detailInfo.setReversed1(loanFlag);
                detailInfo.setReversed2(seqNo);
                detailInfo.setReceiptNo(transferFlowNo);
                detailInfos.add(detailInfo);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u62a5\u6587\u5931\u8d25--%s", (String)"HisDetailParser_4", (String)"ebg-receipt-banks-czccb-dc", (Object[])new Object[0]), body), (Throwable)e);
        }
        return detailInfos;
    }
}

