/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.receipt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.CmbOpaCommConfig;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.api.AsyCalHdRequestImpl;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.ReponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        long taskId = request.getTaskId();
        DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        DownloadListTask task = downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = request.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        CmbOpaCommConfig cmbOpaCommConfig = (CmbOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(CmbOpaCommConfig.class, request.getBankLoginId());
        RequestContextUtils.setRunningParam((String)"primod", (String)cmbOpaCommConfig.getFile_format());
        ArrayList<String> list = new ArrayList<String>(16);
        this.getReceipt_ASYCALHD(task, "1", list, null);
        this.getReceipt_ASYCALHD(task, "2", list, null);
        logger.info("\u7535\u5b50\u56de\u5355\u5f02\u6b65\u67e5\u8be2\u5230\u7684\u4efb\u52a1\u7f16\u53f7\u7684list.size() = {}", (Object)list.size());
        if (list.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\uff1a\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        }
        DownloadListDetail detail = null;
        for (String id : list) {
            detail = new DownloadListDetail();
            String fileName = accNo + "-" + transDateStr + "-" + Sequence.gen8Sequence() + ".zip";
            detail.setFileName(fileName);
            detail.setFileLink(id);
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public void getReceipt_ASYCALHD(DownloadListTask task, String rrcflg, List<String> list, JSONObject ctnkeyz2Json) {
        BankReceiptRequest bankReceiptRequest;
        BankReceiptResponseEB receiptResponseEB;
        String receiptResponse;
        JSONObject ctnkeyz2;
        AsyCalHdRequestImpl asyCalHdRequest = new AsyCalHdRequestImpl();
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)16);
        if (ctnkeyz2Json != null) {
            paramsMap.put("body", ctnkeyz2Json);
        }
        if ((ctnkeyz2 = ReponseParser.receiptParse_ASYCALHD(receiptResponse = (String)(receiptResponseEB = (BankReceiptResponseEB)asyCalHdRequest.doBiz((BankRequest)(bankReceiptRequest = BankReceiptRequest.builder().transDate(task.getTransDate()).accNo(task.getAccNo()).requestStr(rrcflg).paramsMap((Map)paramsMap).build()))).getData(), list)) == null || ctnkeyz2.size() == 0) {
            return;
        }
        this.getReceipt_ASYCALHD(task, rrcflg, list, ctnkeyz2);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMB_OPA_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u62db\u884c\u65e0\u524d\u7f6e\u673a\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

