/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.receipt.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.info.ReceiptInfo;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;

public class ReponseParser {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(ReponseParser.class);

    public static List<ReceiptInfo> receiptParse(String receiptResponse) {
        JSONObject request = JSONObject.parseObject((String)receiptResponse);
        JSONObject response = request.getJSONObject("response");
        JSONObject head = response.getJSONObject("head");
        String resultcode = head.getString("resultcode");
        String resultmsg = head.getString("resultmsg");
        if (!"SUC0000".equals(resultcode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u3002\u9519\u8bef\u4ee3\u7801\uff1a%1$s\uff0c\u9519\u8bef\u63cf\u8ff0\uff1a%2$s\u3002", (String)"ReponseParser_6", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), resultcode, resultmsg));
        }
        JSONObject body = response.getJSONObject("body");
        JSONArray csrrcfdfz2 = body.getJSONArray("csrrcfdfz2");
        if (csrrcfdfz2 == null || csrrcfdfz2.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\u4e2d\u6ca1\u6709\u56de\u5355\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4ea4\u6613\u660e\u7ec6\u662f\u5426\u5b58\u5728\u3002", (String)"ReponseParser_2", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        }
        ArrayList<ReceiptInfo> receiptInfoList = new ArrayList<ReceiptInfo>(16);
        for (int i = 0; i < csrrcfdfz2.size(); ++i) {
            JSONObject obiect = csrrcfdfz2.getJSONObject(i);
            String filnam = obiect.getString("filnam");
            String fillen = obiect.getString("fillen");
            String fildat = obiect.getString("fildat");
            ReceiptInfo info = new ReceiptInfo();
            info.setFILNAM(filnam);
            info.setFILLEN(fillen);
            info.setFILDAT(fildat);
            receiptInfoList.add(info);
        }
        log.info("\u7535\u5b50\u56de\u5355\u67e5\u8be2\uff08DCFDFBRT\uff09\u54cd\u5e94\u62a5\u6587-\u56de\u5355\u6570\u91cf\uff1a{}", (Object)receiptInfoList.size());
        return receiptInfoList;
    }

    public static JSONObject receiptParse_ASYCALHD(String receiptResponse, List<String> list) {
        JSONObject request = JSONObject.parseObject((String)receiptResponse);
        JSONObject response = request.getJSONObject("response");
        JSONObject head = response.getJSONObject("head");
        String resultcode = head.getString("resultcode");
        String resultmsg = head.getString("resultmsg");
        if (!"SUC0000".equals(resultcode)) {
            if (EBGStringUtils.isNotEmpty((String)resultmsg) && resultmsg.contains(PropertiesConstantsUtils.getValue((String)"NOT_DATA")) || resultcode.equals("DCASY02")) {
                return null;
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%1$s\uff0c\u9519\u8bef\u63cf\u8ff0\uff1a%2$s\u3002", (String)"ReponseParser_7", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), resultcode, resultmsg));
        }
        JSONObject body = response.getJSONObject("body");
        JSONObject ctnkeyz2 = body.getJSONObject("ctnkeyz2");
        JSONObject asycalhdz1 = body.getJSONObject("asycalhdz1");
        if (asycalhdz1 == null || asycalhdz1.size() == 0) {
            return ctnkeyz2;
        }
        String rtndat = asycalhdz1.getString("rtndat");
        list.add(rtndat);
        return ctnkeyz2;
    }

    public static String receiptParse_DCTASKID(String receiptResponse) {
        JSONObject request = JSONObject.parseObject((String)receiptResponse);
        JSONObject response = request.getJSONObject("response");
        JSONObject head = response.getJSONObject("head");
        String resultcode = head.getString("resultcode");
        String resultmsg = head.getString("resultmsg");
        if ("PRTASYNC".equals(resultcode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%1$s\uff0c\u9519\u8bef\u63cf\u8ff0\uff1a%2$s\u3002", (String)"ReponseParser_8", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), resultcode, PropertiesConstantsUtils.getValue((String)"BANK_PROCESS")));
        }
        if (!"SUC0000".equals(resultcode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%1$s\uff0c\u9519\u8bef\u63cf\u8ff0\uff1a%2$s\u3002", (String)"ReponseParser_8", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), resultcode, resultmsg));
        }
        JSONObject body = response.getJSONObject("body");
        String fileurl = body.getString("fileurl");
        if (StringUtils.isEmpty((String)fileurl)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"DCTASKID\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\uff1a%1$s\uff0c\u9519\u8bef\u63cf\u8ff0\uff1a%2$s-fileurl\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"ReponseParser_9", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), resultcode, resultmsg));
        }
        return fileurl;
    }
}

