/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;

public class DCCryptor {
    public static byte[] CMBSM4EncryptWithCBC(byte[] key, byte[] iv, byte[] input) throws Exception {
        if (key == null || iv == null || input == null) {
            throw new Exception(ResManager.loadKDString((String)"CMBSM4EncryptWithCBC \u975e\u6cd5\u8f93\u5165\u3002", (String)"DCCryptor_0", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        }
        return DCCryptor.CMBSM4Crypt(key, iv, input, 1);
    }

    public static byte[] CMBSM4DecryptWithCBC(byte[] key, byte[] iv, byte[] input) {
        if (key == null || iv == null || input == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"CMBSM4DecryptWithCBC \u975e\u6cd5\u8f93\u5165\u3002", (String)"DCCryptor_1", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        }
        return DCCryptor.CMBSM4Crypt(key, iv, input, 2);
    }

    public static byte[] CMBSM2SignWithSM3(byte[] id, byte[] privkey, byte[] msg) throws Exception {
        if (privkey == null || msg == null) {
            throw new Exception("CMBSM2SignWithSM3 input error");
        }
        ECPrivateKeyParameters privateKey = DCCryptor.encodePrivateKey(privkey);
        SM2Signer signer = new SM2Signer();
        ParametersWithID parameters = new ParametersWithID((CipherParameters)privateKey, id);
        signer.init(true, (CipherParameters)parameters);
        signer.update(msg, 0, msg.length);
        return DCCryptor.decodeDERSignature(signer.generateSignature());
    }

    public static boolean CMBSM2VerifyWithSM3(byte[] id, byte[] pubkey, byte[] msg, byte[] signature) throws Exception {
        if (pubkey == null || msg == null || signature == null) {
            throw new Exception("CMBSM2VerifyWithSM3 input error");
        }
        ECPublicKeyParameters publicKey = DCCryptor.encodePublicKey(pubkey);
        SM2Signer signer = new SM2Signer();
        ParametersWithID parameters = new ParametersWithID((CipherParameters)publicKey, id);
        signer.init(false, (CipherParameters)parameters);
        signer.update(msg, 0, msg.length);
        return signer.verifySignature(DCCryptor.encodeDERSignature(signature));
    }

    private static byte[] CMBSM4Crypt(byte[] key, byte[] iv, byte[] input, int mode) {
        try {
            SecretKeySpec spec = new SecretKeySpec(key, "SM4");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("SM4/CBC/PKCS7Padding", "BC");
            cipher.init(mode, (Key)spec, ivParameterSpec);
            return cipher.doFinal(input);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private static ECPrivateKeyParameters encodePrivateKey(byte[] value) {
        BigInteger d = new BigInteger(1, value);
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
        ECDomainParameters ecParameters = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
        return new ECPrivateKeyParameters(d, ecParameters);
    }

    private static ECPublicKeyParameters encodePublicKey(byte[] value) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        System.arraycopy(value, 1, x, 0, 32);
        System.arraycopy(value, 33, y, 0, 32);
        BigInteger X = new BigInteger(1, x);
        BigInteger Y = new BigInteger(1, y);
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
        ECPoint Q = spec.getCurve().createPoint(X, Y);
        ECDomainParameters ecParameters = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
        return new ECPublicKeyParameters(Q, ecParameters);
    }

    private static byte[] decodeDERSignature(byte[] signature) throws Exception {
        ASN1InputStream stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(signature));
        ASN1Sequence primitive = (ASN1Sequence)stream.readObject();
        Enumeration enumeration = primitive.getObjects();
        BigInteger R = ((ASN1Integer)enumeration.nextElement()).getValue();
        BigInteger S = ((ASN1Integer)enumeration.nextElement()).getValue();
        byte[] bytes = new byte[64];
        byte[] r = DCCryptor.format(R.toByteArray());
        byte[] s = DCCryptor.format(S.toByteArray());
        System.arraycopy(r, 0, bytes, 0, 32);
        System.arraycopy(s, 0, bytes, 32, 32);
        return bytes;
    }

    private static byte[] encodeDERSignature(byte[] signature) throws Exception {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(signature, 0, r, 0, 32);
        System.arraycopy(signature, 32, s, 0, 32);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, r)));
        vector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, s)));
        return new DERSequence(vector).getEncoded();
    }

    private static byte[] format(byte[] value) {
        if (value.length == 32) {
            return value;
        }
        byte[] bytes = new byte[32];
        if (value.length > 32) {
            System.arraycopy(value, value.length - 32, bytes, 0, 32);
        } else {
            System.arraycopy(value, 0, bytes, 32 - value.length, value.length);
        }
        return bytes;
    }
}

