/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.Base64;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.GetStore;

public class SignWithRSA {
    private static PrivateKey privateKey;

    public static PrivateKey getPrivateKeyFromBytes(String crtBase64, String type) {
        try {
            byte[] baKey = Base64.decode(crtBase64);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(type.equalsIgnoreCase("PKCS") ? new PKCS8EncodedKeySpec(baKey) : new X509EncodedKeySpec(baKey));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u79c1\u94a5\u5931\u8d25%s\u3002", (String)"SignWithRSA_6", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static boolean signRsa2048Verify(byte[] baSource, byte[] baSignature) {
        String pubKeystr = GetStore.getBank();
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decode(pubKeystr));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey key = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(key);
            signature.update(baSource);
            return signature.verify(baSignature);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25%s", (String)"SignWithRSA_7", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static boolean verify(String strToSign, String strSign) {
        String pubKeystr = GetStore.getBank();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = Base64.decode(pubKeystr);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(pubKey);
            signature.update(strToSign.getBytes("UTF-8"));
            boolean bverify = signature.verify(Base64.decode(strSign));
            return bverify;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25:%s\u3002", (String)"SignWithRSA_8", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static String encryptAES256Str(String content) {
        String privateKeystr = GetStore.getRSA();
        if (StringUtils.isEmpty((String)privateKeystr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u627e\u4e0d\u5230RSA\u5bc6\u94a5\u3002", (String)"SignWithRSA_3", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        }
        return SignWithRSA.encryptAES256Str(privateKeystr, content);
    }

    public static String encryptAES256Str(String privateKeyStr, String content) {
        try {
            privateKey = SignWithRSA.getPrivateKeyFromBytes(privateKeyStr, "PKCS");
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(privateKey);
            signature.update(content.getBytes("UTF-8"));
            return Base64.encode(signature.sign());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25%s", (String)"SignWithRSA_9", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static String encryptPlateFormRsaStr(String content) {
        String privateKeystr = GetStore.getPlateFormRSA();
        if (StringUtils.isEmpty((String)privateKeystr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5e73\u53f0RSA\u5bc6\u94a5\u3002", (String)"SignWithRSA_5", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        }
        return SignWithRSA.encryptAES256Str(privateKeystr, content);
    }

    public static byte[] encryptAES256(String content, byte[] bytePassword) {
        try {
            Cipher cipherInstance = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");
            SecretKeySpec key = new SecretKeySpec(bytePassword, "AES");
            cipherInstance.init(1, key);
            byte[] byteContent = content.getBytes("UTF-8");
            return cipherInstance.doFinal(byteContent);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return bytePassword;
        }
    }
}

