/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.reconciliation;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationDownloadHandleImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReconciliationDownloadImpl
extends AbstractBankReconciliationDownloadHandleImpl
implements IBankReconciliationHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(kd.ebg.receipt.banks.ceb.dc.service.reconciliation.BankReconciliationDownloadImpl.class);

    public boolean match(BankReconciliationHandleRequest request) {
        if (request == null) {
            return false;
        }
        if (!RequestContextUtils.isSupportReconciliation((String)EBContext.getContext().getBankLoginID())) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u4e0d\u652f\u6301\u5bf9\u8d26\u5355\u3002", (String)"", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReconciliationHandleResponseEB doBiz(BankReconciliationHandleRequest request) {
        String bankLoginId = request.getBankLoginId();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String accNo = request.getAccNo();
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getReconciliationFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        List downloadListDetails = request.getDetails();
        ArrayList result = new ArrayList(16);
        String bankLogin = EBContext.getContext().getBankLoginID();
        String bakPathParentPath = FileStorageUtil.getReconciliationFileBakPath((String)bankLogin) + File.separator + transDateStr;
        ReconciliationInfo task = request.getTask();
        for (ReconciliationDetail downloadListDetail : downloadListDetails) {
            String downloadURL = downloadListDetail.getFileLink();
            String zipName = downloadListDetail.getFileName();
            DownloadUtils.download((String)downloadURL, (String)zipName, (String)bakPathParentPath);
        }
        for (ReconciliationDetail downloadListDetail : downloadListDetails) {
            String zipName = downloadListDetail.getFileName();
            String key = zipName.substring(0, zipName.indexOf("_reconciliation_ofd.tar.gz"));
            String destDir = bakFilePath + File.separator + key;
            BankReconciliationDownloadImpl.readAndExtractTar(bakPathParentPath + File.separator + zipName, destDir);
            try {
                Stream<Path> paths = Files.walk(Paths.get(destDir, new String[0]), new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(f -> {
                        if (FileCommonUtils.moveFile((File)f, (String)bakFilePath, (String)f.getName())) {
                            ReconciliationDetail detail = new ReconciliationDetail();
                            detail.setFileLink(f.getName());
                            detail.setFileName(f.getName());
                            detail.setTransDate(task.getTransDate());
                            result.add(detail);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (paths == null) continue;
                    if (throwable != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    paths.close();
                }
            }
            catch (IOException e) {
                logger.info("\u626b\u63cf\u6587\u4ef6\u5939{}\u5f02\u5e38", (Object)destDir);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return BankReconciliationHandleResponseEB.success(result);
    }

    public static void readAndExtractTar(String filePath, String destPath) {
        File tarFile;
        String tarFilePath = filePath.replace(" ", "").replace(".gz", "").replaceAll(" ", "");
        if (GZFileUtils.unGzFile((String)filePath, (String)tarFilePath)) {
            logger.info("gz {}\u89e3\u538b\u6210\u529f", (Object)filePath);
            if (GZFileUtils.unTarFiles((String)tarFilePath, (String)destPath)) {
                logger.info("tar {}\u89e3\u538b\u6210\u529f", (Object)tarFilePath);
            }
        }
        if ((tarFile = FileCommonUtils.getFileByPath((String)tarFilePath)).exists()) {
            FileCommonUtils.deleteFile((String)tarFilePath);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

